/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.commands;

import com.ssl.doc.signing.tool.commands.BatchSignHashCommand;
import com.ssl.doc.signing.tool.csc.CscApi;
import com.ssl.doc.signing.tool.exception.AccessTokenException;
import com.ssl.doc.signing.tool.exception.CscApiException;
import com.ssl.doc.signing.tool.office.OfficeSignature;
import com.ssl.doc.signing.tool.office.OfficeSignatureInfo;
import com.ssl.doc.signing.tool.pdf.PdfSignature;
import com.ssl.doc.signing.tool.pdf.PdfSignatureInfo;
import com.ssl.doc.signing.tool.util.AccessToken;
import de.taimos.totp.TOTP;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Calendar;
import java.util.List;
import java.util.Properties;
import java.util.Random;
import java.util.Scanner;
import java.util.TimeZone;
import java.util.stream.Stream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.xml.security.Init;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackageRelationshipCollection;
import org.openxml4j.opc.signature.RelationshipTransformProvider;
import org.w3c.dom.Document;
import picocli.CommandLine;

@CommandLine.Command(name="batch_sign", description={"Batch sign"}, version={"v1.2.1"}, mixinStandardHelpOptions=true)
public class BatchSignCommand
implements Runnable {
    private static final Logger logger;
    @CommandLine.Option(names={"-username"}, description={"RA username"}, required=true)
    private String username;
    @CommandLine.Option(names={"-password"}, description={"RA password"}, required=true)
    private String password;
    @CommandLine.Option(names={"-credential_id"}, description={"Credential ID"}, required=false)
    private String credentialId;
    @CommandLine.Option(names={"-input_dir_path"}, description={"Input directory path where to pick unsigned files"}, required=true)
    private String inputDirPath;
    @CommandLine.Option(names={"-output_dir_path"}, description={"Directory where signed code objects will be written"}, required=false)
    private String outputDirPath;
    @CommandLine.Option(names={"-totp_secret"}, description={"TOTP secret"}, required=false)
    private String totpSecret;
    @CommandLine.Option(names={"-signing_reason"}, description={"Signing reason"}, required=false)
    private String signingReason;
    @CommandLine.Option(names={"-signing_location"}, description={"Signing location - PDF document only"}, required=false)
    private String signingLocation;
    @CommandLine.Option(names={"-contact_info"}, description={"Contact info - PDF document only"}, required=false)
    private String contactInfo;
    @CommandLine.Option(names={"-sig_field_position"}, description={"Signature field position - PDF document only"}, required=false)
    private String sigFieldPosition;
    @CommandLine.Option(names={"-page_no"}, description={"Page number - PDF document only"}, required=false)
    private String pageNo;

    @Override
    public void run() {
        try {
            File[] listFiles;
            logger.info("Command: Batch sign command");
            Properties props = new Properties();
            props.load(new FileInputStream("./conf/doc_sign_tool.properties"));
            String clientId = props.getProperty("CLIENT_ID");
            logger.info("Client ID: " + clientId);
            String oauth2Endpoint = props.getProperty("OAUTH2_ENDPOINT");
            logger.info("OAuth2 URL: " + oauth2Endpoint);
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            String tsaUrl = props.getProperty("TSA_URL");
            logger.info("TSA URL: " + tsaUrl);
            File inputDir = new File(this.inputDirPath);
            if (!inputDir.exists()) {
                logger.info("Not a valid input directory: " + inputDir);
                System.out.print("Error: Not a valid input directory - " + inputDir);
                return;
            }
            if (!this.checkValidInputDir(inputDir)) {
                return;
            }
            AccessToken accessTokenObj = new AccessToken(clientId, this.username, this.password, oauth2Endpoint);
            String accessToken = accessTokenObj.getAccessToken();
            CscApi cscApi = new CscApi(accessToken, cscEndpoint);
            boolean isDocSigningCert = true;
            String[] dsCredentialIds = cscApi.getCredentialIDs("DS");
            String[] esealCredentialIds = cscApi.getCredentialIDs("DS_ESEAL");
            String[] credentialIds = null;
            if (this.credentialId != null && !this.credentialId.equals("")) {
                logger.info("Credential ID in input parameter: " + this.credentialId);
                List<String> credentialList = Arrays.asList(dsCredentialIds);
                if (credentialList.contains(this.credentialId)) {
                    isDocSigningCert = true;
                } else {
                    credentialList = Arrays.asList(esealCredentialIds);
                    if (credentialList.contains(this.credentialId)) {
                        isDocSigningCert = false;
                    } else {
                        logger.info("invalid credential_id in request: " + this.credentialId);
                        System.out.print("Error: Invalid credential_id in request: " + this.credentialId);
                        return;
                    }
                }
                credentialIds = new String[]{this.credentialId};
            } else {
                logger.info("No credential ID provided in input parameter");
                credentialIds = (String[])Stream.concat(Arrays.stream(dsCredentialIds), Arrays.stream(esealCredentialIds)).toArray(String[]::new);
                if (credentialIds.length == 0) {
                    logger.info("No credential ID found for this user");
                    System.out.print("Error: No credential ID found for this user");
                    return;
                }
                if (credentialIds.length > 1) {
                    System.out.println("Document Signing Credential ID(s): ");
                    for (String credId : dsCredentialIds) {
                        logger.info("Credential ID: " + credId);
                        System.out.println("- " + credId);
                    }
                    System.out.println("Document seal Credential ID(s): ");
                    for (String credId : esealCredentialIds) {
                        logger.info("Credential ID: " + credId);
                        System.out.println("- " + credId);
                    }
                    return;
                }
                if (credentialIds.length == 1 && dsCredentialIds.length == 1) {
                    isDocSigningCert = true;
                } else if (credentialIds.length == 1 && esealCredentialIds.length == 1) {
                    isDocSigningCert = false;
                }
            }
            this.credentialId = credentialIds[0];
            logger.info("Credential ID retrieved from signatures service: " + this.credentialId);
            List<X509Certificate> certs = cscApi.getCredentialInfo(credentialIds[0]);
            logger.info("Subject DN: " + certs.get(0).getSubjectDN());
            logger.info("Issuer DN: " + certs.get(0).getIssuerDN());
            logger.info("Certificate expiry: " + certs.get(0).getNotAfter());
            ArrayList<String> hashesList = new ArrayList<String>();
            ArrayList<PdfSignatureInfo> pdfSignatureInfoList = new ArrayList<PdfSignatureInfo>();
            ArrayList<OfficeSignatureInfo> officeSignatureInfoList = new ArrayList<OfficeSignatureInfo>();
            logger.info("Input directory path: " + this.inputDirPath);
            File inputPath = new File(this.inputDirPath);
            for (File file : listFiles = inputPath.listFiles()) {
                String fileExtension = FilenameUtils.getExtension((String)file.getName());
                logger.info("File extension: " + fileExtension);
                if (fileExtension.equals("pdf")) {
                    float x = -1.0f;
                    float y = -1.0f;
                    float width = -1.0f;
                    float height = -1.0f;
                    int pageNumber = -1;
                    if (this.sigFieldPosition != null && this.pageNo != null) {
                        logger.info("Signature field position values: " + this.sigFieldPosition);
                        String[] sigFieldPositionArray = this.sigFieldPosition.split(",");
                        if (sigFieldPositionArray.length != 4) {
                            logger.info("Invalid signature field position value. Must be of form x, y,widhth,height");
                            System.out.print("Error: Invalid signature field position value. Must be of form x, y,widhth,height");
                            return;
                        }
                        try {
                            x = Float.parseFloat(sigFieldPositionArray[0]);
                            y = Float.parseFloat(sigFieldPositionArray[1]);
                            width = Float.parseFloat(sigFieldPositionArray[2]);
                            height = Float.parseFloat(sigFieldPositionArray[3]);
                        }
                        catch (NumberFormatException ex) {
                            logger.error("", (Throwable)ex);
                            System.out.print("Error: Format of signature field position values is not valid");
                            return;
                        }
                        try {
                            pageNumber = Integer.parseInt(this.pageNo) - 1;
                            logger.info("Page number: " + pageNumber);
                        }
                        catch (NumberFormatException ex) {
                            logger.error("", (Throwable)ex);
                            System.out.print("Error: Invalid page number format");
                            return;
                        }
                    }
                    long docId = new Random().nextLong();
                    PdfSignatureInfo signatureInfo = new PdfSignatureInfo();
                    signatureInfo.setDocumentId(docId);
                    signatureInfo.setX(x);
                    signatureInfo.setY(y);
                    signatureInfo.setWidth(width);
                    signatureInfo.setHeight(height);
                    signatureInfo.setPageNo(pageNumber);
                    signatureInfo.setSigningReason(this.signingReason);
                    signatureInfo.setSigningLocation(this.signingLocation);
                    signatureInfo.setContactInfo(this.contactInfo);
                    signatureInfo.setSignDate(Calendar.getInstance());
                    signatureInfo.setCredentialId(credentialIds[0]);
                    PdfSignature pdfSig = new PdfSignature(file, certs);
                    pdfSig.setSignatureInfo(signatureInfo);
                    String hash = pdfSig.getHash();
                    hashesList.add(hash);
                    pdfSignatureInfoList.add(signatureInfo);
                    continue;
                }
                Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                String signingTime = sdf.format(now.getTime()) + "Z";
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setNamespaceAware(true);
                dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                Document doc = dbf.newDocumentBuilder().newDocument();
                Package container = Package.open((String)file.getAbsolutePath(), (PackageAccess)PackageAccess.READ_WRITE);
                OfficeSignature officeSignature = new OfficeSignature(container, doc, certs, signingTime);
                officeSignature.setSigningReason(this.signingReason);
                String hash = officeSignature.getHash();
                OfficeSignatureInfo signatureInfo = new OfficeSignatureInfo();
                signatureInfo.setSigningTime(signingTime);
                signatureInfo.setHash(hash);
                signatureInfo.setSigningReason(this.signingReason);
                signatureInfo.setCredentialId(this.credentialId);
                hashesList.add(hash);
                officeSignatureInfoList.add(signatureInfo);
            }
            String[] hashes = new String[hashesList.size()];
            hashesList.toArray(hashes);
            PdfSignatureInfo[] pdfSignatureInfos = null;
            OfficeSignatureInfo[] officeSignatureInfos = null;
            if (pdfSignatureInfoList.size() > 0) {
                pdfSignatureInfos = new PdfSignatureInfo[pdfSignatureInfoList.size()];
                pdfSignatureInfoList.toArray(pdfSignatureInfos);
            } else {
                officeSignatureInfos = new OfficeSignatureInfo[officeSignatureInfoList.size()];
                officeSignatureInfoList.toArray(officeSignatureInfos);
            }
            String otp = null;
            if (isDocSigningCert) {
                if (this.totpSecret == null || this.totpSecret.equals("")) {
                    System.out.print("Enter the OTP - Press enter to continue: ");
                    Scanner otpInput = new Scanner(System.in);
                    otp = otpInput.nextLine();
                    if (otp == null || otp.equals("")) {
                        System.out.print("Error: OTP not provided");
                        return;
                    }
                } else {
                    byte[] totpSeed = Base64.getDecoder().decode(this.totpSecret);
                    String hexKey = Hex.encodeHexString((byte[])totpSeed);
                    otp = TOTP.getOTP((String)hexKey);
                }
            } else {
                if (this.totpSecret != null) {
                    logger.info("TOTP secret must not be present for eseal");
                    System.out.print("Error: TOTP secret must not be present for eseal");
                    return;
                }
                if (otp != null) {
                    logger.info("OTP must not be present for eseal");
                    System.out.print("Error: OTP must not be present for eseal");
                    return;
                }
            }
            String sad = cscApi.getCredentialsAuthorize(this.credentialId, hashes.length, hashes, otp);
            String[] signatures = cscApi.signHash(this.credentialId, sad, hashes, "1.2.840.113549.1.1.11");
            List<List<byte[]>> revInfos = PdfSignature.getRevocationInformation(certs);
            int i = 0;
            for (File file : listFiles) {
                String fileExtension = FilenameUtils.getExtension((String)file.getName());
                byte[] signedDocument = null;
                if (fileExtension.equals("pdf")) {
                    PdfSignature pdfSig = new PdfSignature(file, certs);
                    pdfSig.setTsaUrl(tsaUrl);
                    pdfSig.setSignatureInfo(pdfSignatureInfos[i]);
                    byte[] signedTimestampedPdf = pdfSig.embedSignature(Base64.getDecoder().decode(signatures[i]));
                    signedDocument = pdfSig.longTermValidation(signedTimestampedPdf, revInfos);
                } else {
                    Package container = Package.open((String)file.getAbsolutePath(), (PackageAccess)PackageAccess.READ_WRITE);
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    Document doc = dbf.newDocumentBuilder().newDocument();
                    OfficeSignature officeSignature = new OfficeSignature(container, doc, certs, officeSignatureInfos[i].getSigningTime());
                    officeSignature.setSigningReason(officeSignatureInfos[i].getSigningReason());
                    signedDocument = officeSignature.sign(signatures[i]);
                }
                FileOutputStream fout = new FileOutputStream(this.outputDirPath + File.separator + file.getName());
                fout.write(signedDocument);
                fout.close();
                ++i;
            }
            System.out.println("Batch sign command executed successfully. Output directory for signed files: " + this.outputDirPath);
        }
        catch (AccessTokenException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }

    private boolean checkValidInputDir(File inputDirPath) throws Exception {
        File[] listFiles;
        boolean pdfDocPresent = false;
        boolean officeDocPresent = false;
        for (File file : listFiles = inputDirPath.listFiles()) {
            if (file.isDirectory()) {
                logger.info("Directory must not be present: " + file.getName());
                System.out.print("Error: Directory must not be present: " + file.getName());
                return false;
            }
            if (!file.isFile()) continue;
            String fileExtension = FilenameUtils.getExtension((String)file.getName());
            if (fileExtension.equals("pdf")) {
                pdfDocPresent = true;
                if (!officeDocPresent) continue;
                logger.info("Either all PDF or Office(docx, xlsx and pptx) documents must present");
                System.out.print("Error: Either all PDF or Office(docx, xlsx and pptx) documents must present");
                return false;
            }
            if (fileExtension.equals("docx") || fileExtension.equals("xlsx") || fileExtension.equals("pptx")) {
                officeDocPresent = true;
                if (pdfDocPresent) {
                    logger.info("Either all PDF or Office(docx, xlsx and pptx) documents must present");
                    System.out.print("Error: Either all PDF or Office(docx, xlsx and pptx) documents must present");
                    return false;
                }
                Package container = Package.open((String)file.getAbsolutePath(), (PackageAccess)PackageAccess.READ_WRITE);
                PackageRelationshipCollection dsigOriginPartTypeRelationships = container.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (dsigOriginPartTypeRelationships.size() == 0) continue;
                logger.info("Document already signed: " + file.getName());
                System.out.print("Error: document already signed: " + file.getName());
                return false;
            }
            logger.info("Error: File extension not allowed: " + file.getName());
            System.out.print("Error: File extension not allowed: " + file.getName());
            return false;
        }
        if (listFiles.length > 100) {
            logger.info("max 100 files are allowed. Current file count is: " + listFiles.length);
            System.out.print("max 100 files are allowed. Current file count is: " + listFiles.length);
            return false;
        }
        return true;
    }

    static {
        try {
            FileInputStream inputStream = new FileInputStream("./conf/log4j2.xml");
            ConfigurationSource source = new ConfigurationSource((InputStream)inputStream);
            Configurator.initialize(null, (ConfigurationSource)source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Init.init();
        RelationshipTransformProvider.InstallProvider();
        logger = LogManager.getLogger(BatchSignHashCommand.class);
    }
}

