/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.commands;

import com.ssl.doc.signing.tool.csc.CscApi;
import com.ssl.doc.signing.tool.exception.CscApiException;
import com.ssl.doc.signing.tool.office.OfficeSignature;
import com.ssl.doc.signing.tool.office.OfficeSignatureInfo;
import com.ssl.doc.signing.tool.pdf.PdfSignature;
import com.ssl.doc.signing.tool.pdf.PdfSignatureInfo;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import org.apache.xml.security.Init;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackageRelationshipCollection;
import org.openxml4j.opc.signature.RelationshipTransformProvider;
import org.w3c.dom.Document;
import picocli.CommandLine;

@CommandLine.Command(name="batch_sign_hash", description={"Batch sign of pre-computed hash(es)"}, version={"v1.2.1"}, mixinStandardHelpOptions=true)
public class BatchSignHashCommand
implements Runnable {
    private static final Logger logger;
    @CommandLine.Option(names={"-access_token"}, description={"Access token"}, required=true)
    private String accessToken;
    @CommandLine.Option(names={"-input_dir_path"}, description={"Input directory path where to pick unsigned files and correspondinghash files for signing"}, required=true)
    private String inputDirPath;
    @CommandLine.Option(names={"-output_dir_path"}, description={"Output directory to place signed files"}, required=true)
    private String outputDirPath;
    @CommandLine.Option(names={"-otp"}, description={"OTP value"}, required=false)
    private String otp;

    @Override
    public void run() {
        try {
            logger.info("Command: Batch sign hash");
            Properties props = new Properties();
            props.load(new FileInputStream("./conf/doc_sign_tool.properties"));
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            String tsaUrl = props.getProperty("TSA_URL");
            logger.info("TSA URL: " + tsaUrl);
            File inputDirFile = new File(this.inputDirPath);
            if (!inputDirFile.exists()) {
                logger.info("Not a valid input directory: " + this.inputDirPath);
                System.out.print("Error: Not a valid input directory - " + this.inputDirPath);
                return;
            }
            File outputDirFile = new File(this.outputDirPath);
            if (!outputDirFile.exists()) {
                logger.info("Not a valid output directory: " + this.outputDirPath);
                System.out.print("Error: Not a valid output directory - " + this.outputDirPath);
                return;
            }
            HashMap<String, String> filesInfo = this.validateInputDirectory(inputDirFile);
            if (filesInfo == null) {
                return;
            }
            CscApi cscApi = new CscApi(this.accessToken, cscEndpoint);
            String credentialId = null;
            boolean isDocSigningCert = true;
            ArrayList<String> hashesList = new ArrayList<String>();
            for (String metaFileName : filesInfo.keySet()) {
                Serializable metadata;
                File file = new File(this.inputDirPath + File.separator + metaFileName);
                FileInputStream finMetadata = new FileInputStream(file);
                ObjectInputStream objMetadata = new ObjectInputStream(finMetadata);
                if (file.getName().contains("pdf")) {
                    metadata = (PdfSignatureInfo)objMetadata.readObject();
                    hashesList.add(((PdfSignatureInfo)metadata).getHash());
                    credentialId = ((PdfSignatureInfo)metadata).getCredentialId();
                    isDocSigningCert = ((PdfSignatureInfo)metadata).isDocSigningCert();
                } else {
                    metadata = (OfficeSignatureInfo)objMetadata.readObject();
                    hashesList.add(((OfficeSignatureInfo)metadata).getHash());
                    credentialId = ((OfficeSignatureInfo)metadata).getCredentialId();
                    isDocSigningCert = ((OfficeSignatureInfo)metadata).isDocSigningCert();
                }
                finMetadata.close();
                objMetadata.close();
            }
            logger.info("doc signing certificate: " + isDocSigningCert);
            if (!isDocSigningCert) {
                if (this.otp != null) {
                    logger.info("OTP must not be present for eseal");
                    System.out.print("Error: OTP must not be present for eseal");
                    return;
                }
            } else if (this.otp == null) {
                logger.info("OTP must be present");
                System.out.print("Error: OTP must be present");
                return;
            }
            String[] hashes = new String[hashesList.size()];
            hashesList.toArray(hashes);
            List<X509Certificate> certs = cscApi.getCredentialInfo(credentialId);
            logger.info("Subject DN: " + certs.get(0).getSubjectDN());
            logger.info("Issuer DN: " + certs.get(0).getIssuerDN());
            logger.info("Certificate expiry: " + certs.get(0).getNotAfter());
            String sad = cscApi.getCredentialsAuthorize(credentialId, hashes.length, hashes, this.otp);
            String[] signatures = cscApi.signHash(credentialId, sad, hashes, "1.2.840.113549.1.1.11");
            List<List<byte[]>> revInfos = PdfSignature.getRevocationInformation(certs);
            int i = 0;
            for (String metaFileName : filesInfo.keySet()) {
                Serializable signatureInfo;
                String unsignedFileName = filesInfo.get(metaFileName);
                File unsignedFile = new File(this.inputDirPath + File.separator + unsignedFileName);
                File metaFile = new File(this.inputDirPath + File.separator + metaFileName);
                FileInputStream finMetadata = new FileInputStream(metaFile);
                ObjectInputStream objMetadata = new ObjectInputStream(finMetadata);
                byte[] signedDocument = null;
                if (metaFileName.contains("pdf")) {
                    signatureInfo = (PdfSignatureInfo)objMetadata.readObject();
                    PdfSignature pdfSig = new PdfSignature(unsignedFile, certs);
                    pdfSig.setTsaUrl(tsaUrl);
                    pdfSig.setSignatureInfo((PdfSignatureInfo)signatureInfo);
                    byte[] signedTimestampedPdf = pdfSig.embedSignature(Base64.getDecoder().decode(signatures[i]));
                    signedDocument = pdfSig.longTermValidation(signedTimestampedPdf, revInfos);
                } else {
                    signatureInfo = (OfficeSignatureInfo)objMetadata.readObject();
                    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                    dbf.setNamespaceAware(true);
                    dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    Document doc = dbf.newDocumentBuilder().newDocument();
                    Package container = Package.open((String)unsignedFile.getAbsolutePath(), (PackageAccess)PackageAccess.READ_WRITE);
                    OfficeSignature officeSignature = new OfficeSignature(container, doc, certs, ((OfficeSignatureInfo)signatureInfo).getSigningTime());
                    officeSignature.setSigningReason(((OfficeSignatureInfo)signatureInfo).getSigningReason());
                    signedDocument = officeSignature.sign(signatures[i]);
                }
                FileOutputStream fout = new FileOutputStream(this.outputDirPath + File.separator + unsignedFileName);
                fout.write(signedDocument);
                fout.close();
                ++i;
            }
            System.out.println("Batch sign hash command executed successfully. Output directory for signed files: " + this.outputDirPath);
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }

    private HashMap<String, String> validateInputDirectory(File inputDir) throws Exception {
        String fileExtension;
        LinkedHashMap<String, String> filesInfo = new LinkedHashMap<String, String>();
        boolean pdfDocPresent = false;
        boolean officeDocPresent = false;
        File[] listFiles = inputDir.listFiles();
        if (listFiles.length > 200) {
            logger.info("Error: only 100 files can be signed in a single batch");
            System.out.print("Error: only 100 files can be signed in a single batch");
            return null;
        }
        for (File file : listFiles) {
            if (file.isDirectory()) {
                logger.info("Error: Directory must not be present: " + file.getName());
                System.out.print("Error: Directory must not be present: " + file.getName());
                return null;
            }
            if (!file.isFile() || !(fileExtension = FilenameUtils.getExtension((String)file.getName())).equals("meta")) continue;
            filesInfo.put(file.getName(), "META");
        }
        for (File file : listFiles) {
            String usignedFilename;
            fileExtension = FilenameUtils.getExtension((String)file.getName());
            if (fileExtension.equals("meta")) continue;
            if (fileExtension.equals("pdf")) {
                pdfDocPresent = true;
                if (officeDocPresent) {
                    logger.info("Either all PDF or Office(docx, xlsx and pptx) documents must present");
                    System.out.print("Error: Either all PDF or Office(docx, xlsx and pptx) documents must present");
                    return null;
                }
            } else if (fileExtension.equals("docx") || fileExtension.equals("xlsx") || fileExtension.equals("pptx")) {
                officeDocPresent = true;
                if (pdfDocPresent) {
                    logger.info("Either all PDF or Office(docx, xlsx and pptx) documents must present");
                    System.out.print("Error: Either all PDF or Office(docx, xlsx and pptx) documents must present");
                    return null;
                }
                Package container = Package.open((String)file.getAbsolutePath(), (PackageAccess)PackageAccess.READ_WRITE);
                PackageRelationshipCollection dsigOriginPartTypeRelationships = container.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
                if (dsigOriginPartTypeRelationships.size() != 0) {
                    logger.info("Document already signed: " + file.getName());
                    System.out.print("Error: document already signed: " + file.getName());
                    return null;
                }
            } else {
                logger.info("Error: File extension not allowed: " + file.getName());
                System.out.print("Error: File extension not allowed: " + file.getName());
                return null;
            }
            if ((usignedFilename = (String)((HashMap)filesInfo).get(file.getName() + ".meta")) == null) {
                logger.info("Error: No matching meta file found against unsigned file: " + file.getName());
                System.out.print("Error: No matching meta file found against unsigned file: " + file.getName());
                return null;
            }
            filesInfo.put(file.getName() + ".meta", file.getName());
        }
        if (filesInfo.size() * 2 != listFiles.length) {
            logger.info("Error: remove extra files from input directory: " + inputDir.getAbsolutePath());
            System.out.print("Error: remove extra files from the input directory: " + inputDir.getAbsolutePath());
            return null;
        }
        return filesInfo;
    }

    static {
        try {
            FileInputStream inputStream = new FileInputStream("./conf/log4j2.xml");
            ConfigurationSource source = new ConfigurationSource((InputStream)inputStream);
            Configurator.initialize(null, (ConfigurationSource)source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        Init.init();
        RelationshipTransformProvider.InstallProvider();
        logger = LogManager.getLogger(BatchSignHashCommand.class);
    }
}

