/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.commands;

import com.ssl.doc.signing.tool.csc.CscApi;
import com.ssl.doc.signing.tool.exception.AccessTokenException;
import com.ssl.doc.signing.tool.exception.CscApiException;
import com.ssl.doc.signing.tool.util.AccessToken;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.cert.X509Certificate;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.Configurator;
import picocli.CommandLine;

@CommandLine.Command(name="credential_info", description={"Returns signing credential information"}, version={"v1.2.1"}, mixinStandardHelpOptions=true)
public class CredentialInfoCommand
implements Runnable {
    private static final Logger logger;
    @CommandLine.Option(names={"-username"}, description={"RA username"}, required=true)
    private String username;
    @CommandLine.Option(names={"-password"}, description={"RA password"}, required=true)
    private String password;
    @CommandLine.Option(names={"-credential_id"}, description={"Credential ID"}, required=true)
    private String credentialId;

    @Override
    public void run() {
        try {
            logger.info("Command: credential_info");
            Properties props = new Properties();
            props.load(new FileInputStream("./conf/doc_sign_tool.properties"));
            String clientId = props.getProperty("CLIENT_ID");
            logger.info("Client ID: " + clientId);
            String oauth2Endpoint = props.getProperty("OAUTH2_ENDPOINT");
            logger.info("OAuth2 URL: " + oauth2Endpoint);
            String cscEndpoint = props.getProperty("CSC_API_ENDPOINT");
            logger.info("CSC Endpoint: " + cscEndpoint);
            AccessToken accessTokenObj = new AccessToken(clientId, this.username, this.password, oauth2Endpoint);
            String accessToken = accessTokenObj.getAccessToken();
            CscApi cscApi = new CscApi(accessToken, cscEndpoint);
            X509Certificate cert = cscApi.getCredentialInfo(this.credentialId).get(0);
            System.out.println("Signing Certificate Subject Information: ");
            logger.info("Subject DN: " + cert.getSubjectDN());
            System.out.println("- Subject DN: " + cert.getSubjectDN());
            logger.info("Certificate Expiry: " + cert.getNotAfter());
            System.out.println("- Certificate Expiry: " + cert.getNotAfter());
            logger.info("Issuer DN: " + cert.getIssuerDN());
            System.out.println("- Issuer DN: " + cert.getIssuerDN());
            logger.info("credential_info command executed successfully");
        }
        catch (AccessTokenException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (CscApiException ex) {
            logger.error("", (Throwable)ex);
            System.out.println("Error: " + ex.getMessage());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            logger.error("", (Throwable)ex);
        }
    }

    static {
        try {
            FileInputStream inputStream = new FileInputStream("./conf/log4j2.xml");
            ConfigurationSource source = new ConfigurationSource((InputStream)inputStream);
            Configurator.initialize(null, (ConfigurationSource)source);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        logger = LogManager.getLogger(CredentialInfoCommand.class);
    }
}

