/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.office;

import com.ssl.doc.signing.tool.constants.Constant;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.security.MessageDigest;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import java.util.UUID;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.io.IOUtils;
import org.apache.xml.security.c14n.Canonicalizer;
import org.dom4j.Document;
import org.dom4j.io.DOMWriter;
import org.dom4j.io.SAXReader;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.PackagingURIHelper;
import org.openxml4j.opc.TargetMode;
import org.openxml4j.opc.signature.RelationshipTransform;
import org.w3c.dom.Element;

public class OfficeSignature {
    private Package container;
    private List<X509Certificate> signerCertChain;
    private String signingTime;
    private org.w3c.dom.Document doc;
    private String signingReason;

    public OfficeSignature(Package container, org.w3c.dom.Document doc, List<X509Certificate> signerCertChain, String signingTime) {
        this.container = container;
        this.doc = doc;
        this.signerCertChain = signerCertChain;
        this.signingTime = signingTime;
    }

    public void setSigningReason(String signingReason) {
        this.signingReason = signingReason;
    }

    public String getHash() throws Exception {
        Element idPackageObject = this.createIdPackageObject(this.container, this.doc, this.signingTime);
        Element idPackageObjectRef = this.createIdPackageObjectRef(this.doc, idPackageObject);
        Element idOfficeObject = this.createIdOfficeObject(this.doc, this.signingReason);
        Element idOfficeObjectRef = OfficeSignature.createIdOfficeObjectRef(this.doc, idOfficeObject);
        Element signedProperties = this.createSignedProperties(this.doc, this.signerCertChain, this.signingTime);
        Element signedPropertiesRef = OfficeSignature.createSignedPropsObjectRef(this.doc, this.signerCertChain, signedProperties);
        Element signedInfo = this.createSignedInfo(this.doc, idPackageObjectRef, idOfficeObjectRef, signedPropertiesRef);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        ByteArrayOutputStream objectOut = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(signedInfo), new StreamResult(objectOut));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        canonicalizer.canonicalize(objectOut.toByteArray(), (OutputStream)out, false);
        byte[] canonXmlBytes = out.toByteArray();
        MessageDigest md = MessageDigest.getInstance(Constant.HASH_ALGO);
        md.update(canonXmlBytes);
        String digest = Base64.getEncoder().encodeToString(md.digest());
        return digest;
    }

    public byte[] sign(String signatureValue) throws Exception {
        URI defaultOriginPartURL = new URI("/_xmlsignatures/origin.sigs");
        PackagePartName defaultOriginPartName = PackagingURIHelper.createPartName((URI)defaultOriginPartURL);
        PackagePart digSigOriginPart = this.container.createPart(defaultOriginPartName, "application/vnd.openxmlformats-package.digital-signature-origin");
        this.container.addRelationship(digSigOriginPart.getPartName(), TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        Element idPackageObject = this.createIdPackageObject(this.container, this.doc, this.signingTime);
        Element idPackageObjectRef = this.createIdPackageObjectRef(this.doc, idPackageObject);
        Element idOfficeObject = this.createIdOfficeObject(this.doc, this.signingReason);
        Element idOfficeObjectRef = OfficeSignature.createIdOfficeObjectRef(this.doc, idOfficeObject);
        Element signedProperties = this.createSignedProperties(this.doc, this.signerCertChain, this.signingTime);
        Element signedPropertiesRef = OfficeSignature.createSignedPropsObjectRef(this.doc, this.signerCertChain, signedProperties);
        Element keyInfo = this.createKeyInfo(this.doc, this.signerCertChain);
        Element signedInfo = this.createSignedInfo(this.doc, idPackageObjectRef, idOfficeObjectRef, signedPropertiesRef);
        Element sigValue = this.doc.createElementNS(Constant.W3C_XML_SIG_NS, "SignatureValue");
        sigValue.appendChild(this.doc.createTextNode(signatureValue));
        Element qualifyingProps = this.doc.createElementNS(Constant.XAdES_NS, "xd:QualifyingProperties");
        qualifyingProps.setAttribute("Target", "#idPackageSignature");
        qualifyingProps.appendChild(signedProperties);
        Element qualifyingPropsObject = this.doc.createElementNS(Constant.W3C_XML_SIG_NS, "Object");
        qualifyingPropsObject.appendChild(qualifyingProps);
        Element signature = this.doc.createElementNS(Constant.W3C_XML_SIG_NS, "Signature");
        signature.setAttribute("Id", "idPackageSignature");
        signature.appendChild(signedInfo);
        signature.appendChild(sigValue);
        signature.appendChild(keyInfo);
        signature.appendChild(idPackageObject);
        signature.appendChild(idOfficeObject);
        signature.appendChild(qualifyingPropsObject);
        this.doc.appendChild(signature);
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        Transformer trans = TransformerFactory.newInstance().newTransformer();
        trans.setOutputProperty("indent", "no");
        trans.setOutputProperty("standalone", "yes");
        trans.transform(new DOMSource(this.doc), new StreamResult(bout));
        UUID uuid = UUID.randomUUID();
        String signaturePartURI = "/_xmlsignatures/" + uuid.toString() + ".xml";
        PackagePart digitalSignatureSignaturePart = this.container.createPart(PackagingURIHelper.createPartName((String)signaturePartURI), "application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml", bout);
        digSigOriginPart.addRelationship(digitalSignatureSignaturePart.getPartName(), TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature");
        ByteArrayOutputStream fout = new ByteArrayOutputStream();
        this.container.save((OutputStream)fout);
        return fout.toByteArray();
    }

    private Element createIdPackageObject(Package container, org.w3c.dom.Document doc, String time) throws Exception {
        Element object = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Object");
        object.setAttribute("Id", "idPackageObject");
        Element manifest = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Manifest");
        ArrayList packagePartArrayList = container.getParts();
        for (PackagePart packagePart : packagePartArrayList) {
            if (packagePart.getPartName().getName().contains("docProps") || packagePart.getPartName().getName().contains("xmlsignatures")) continue;
            InputStream is = packagePart.getInputStream();
            if (packagePart.isRelationshipPart()) {
                SAXReader docReader = new SAXReader();
                Document doc4jRet = docReader.read(is);
                if (packagePart.getPartName().getName().equals("/_rels/.rels")) {
                    org.dom4j.Element root = doc4jRet.getRootElement();
                    List elements = root.elements();
                    for (int i = 0; i < elements.size(); ++i) {
                        org.dom4j.Element elem = (org.dom4j.Element)elements.get(i);
                        if (!elem.attributeValue("Target").contains("docProps") && !elem.attributeValue("Target").contains("xmlsignatures")) continue;
                        elem.detach();
                    }
                }
                ArrayList<String> relIdsToInclude = new ArrayList<String>();
                org.dom4j.Element relationshipsElem = doc4jRet.getRootElement();
                List relationshipElem = relationshipsElem.elements();
                for (int i = 0; i < relationshipElem.size(); ++i) {
                    org.dom4j.Element rel = (org.dom4j.Element)relationshipElem.get(i);
                    relIdsToInclude.add(rel.attributeValue("Id"));
                }
                Document doc4jTra = RelationshipTransform.DoRelationshipTransform((Document)doc4jRet, null, null);
                DOMWriter dw = new DOMWriter();
                org.w3c.dom.Document docRes = dw.write(doc4jTra);
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                ByteArrayOutputStream objectOut = new ByteArrayOutputStream();
                transformer.transform(new DOMSource(docRes.getDocumentElement()), new StreamResult(objectOut));
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
                canonicalizer.canonicalize(objectOut.toByteArray(), (OutputStream)out, false);
                byte[] canonXmlBytes = out.toByteArray();
                String xml = new String(canonXmlBytes);
                xml = xml.replaceAll("word/document.xml", "/word/document.xml");
                xml = xml.replaceAll("xl/workbook.xml", "/xl/workbook.xml");
                xml = xml.replaceAll("ppt/presentation.xml", "/ppt/presentation.xml");
                MessageDigest md = MessageDigest.getInstance(Constant.HASH_ALGO);
                md.update(xml.getBytes());
                String digest = Base64.getEncoder().encodeToString(md.digest());
                Element transformRel = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Transform");
                transformRel.setAttribute("Algorithm", "http://schemas.openxmlformats.org/package/2006/RelationshipTransform");
                for (int i = 0; i < relIdsToInclude.size(); ++i) {
                    Element relRef = doc.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", "RelationshipReference");
                    relRef.setPrefix("mdssi");
                    relRef.setAttribute("SourceId", (String)relIdsToInclude.get(i));
                    relRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
                    transformRel.appendChild(relRef);
                }
                Element transformAlg = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Transform");
                transformAlg.setAttribute("Algorithm", Constant.CAN_ALGO);
                Element transforms = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Transforms");
                transforms.appendChild(transformRel);
                transforms.appendChild(transformAlg);
                Element digestMethod = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestMethod");
                digestMethod.setAttribute("Algorithm", Constant.DIGEST_ALGO);
                Element digestValue = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestValue");
                digestValue.appendChild(doc.createTextNode(digest));
                Element reference = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Reference");
                reference.setAttribute("URI", packagePart.getPartName().getName() + "?ContentType=application/vnd.openxmlformats-package.relationships+xml");
                reference.appendChild(transforms);
                reference.appendChild(digestMethod);
                reference.appendChild(digestValue);
                manifest.appendChild(reference);
                continue;
            }
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            MessageDigest md = MessageDigest.getInstance(Constant.HASH_ALGO);
            md.update(bytes);
            String digest = Base64.getEncoder().encodeToString(md.digest());
            Element digestMethod = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestMethod");
            digestMethod.setAttribute("Algorithm", Constant.DIGEST_ALGO);
            Element digestValue = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestValue");
            digestValue.appendChild(doc.createTextNode(digest));
            Element reference = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Reference");
            reference.setAttribute("URI", packagePart.getPartName().getName() + "?ContentType=" + packagePart.getContentType());
            reference.appendChild(digestMethod);
            reference.appendChild(digestValue);
            manifest.appendChild(reference);
        }
        object.appendChild(manifest);
        Element format = doc.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", "Format");
        format.setPrefix("mdssi");
        format.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        format.appendChild(doc.createTextNode("YYYY-MM-DDThh:mm:ssTZD"));
        Element value = doc.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", "Value");
        value.setPrefix("mdssi");
        value.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        value.appendChild(doc.createTextNode(time));
        Element sigTime = doc.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", "SignatureTime");
        sigTime.setPrefix("mdssi");
        sigTime.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        sigTime.appendChild(format);
        sigTime.appendChild(value);
        Element sigProperty = doc.createElementNS(Constant.W3C_XML_SIG_NS, "SignatureProperty");
        sigProperty.setAttribute("Id", "idSignatureTime");
        sigProperty.setAttribute("Target", "#idPackageSignature");
        sigProperty.appendChild(sigTime);
        Element sigProperties = doc.createElementNS(Constant.W3C_XML_SIG_NS, "SignatureProperties");
        sigProperties.appendChild(sigProperty);
        object.appendChild(sigProperties);
        return object;
    }

    private Element createIdPackageObjectRef(org.w3c.dom.Document doc, Element idPackgObject) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        ByteArrayOutputStream objectOut = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(idPackgObject), new StreamResult(objectOut));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        canonicalizer.canonicalize(objectOut.toByteArray(), (OutputStream)out, false);
        byte[] canonXmlBytes = out.toByteArray();
        MessageDigest md = MessageDigest.getInstance(Constant.HASH_ALGO);
        md.update(canonXmlBytes);
        String digest = Base64.getEncoder().encodeToString(md.digest());
        Element digestMethod = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestMethod");
        digestMethod.setAttribute("Algorithm", Constant.DIGEST_ALGO);
        Element digestValue = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestValue");
        digestValue.appendChild(doc.createTextNode(digest));
        Element idPackgObjectRef = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Reference");
        idPackgObjectRef.setAttribute("URI", "#idPackageObject");
        idPackgObjectRef.setAttribute("Type", "http://www.w3.org/2000/09/xmldsig#Object");
        idPackgObjectRef.appendChild(digestMethod);
        idPackgObjectRef.appendChild(digestValue);
        return idPackgObjectRef;
    }

    private Element createIdOfficeObject(org.w3c.dom.Document doc, String signingReason) throws Exception {
        Element signatureComments = doc.createElementNS("http://schemas.microsoft.com/office/2006/digsig", "SignatureComments");
        signatureComments.appendChild(doc.createTextNode(signingReason));
        Element manifestHashalgo = doc.createElementNS("http://schemas.microsoft.com/office/2006/digsig", "ManifestHashAlgorithm");
        manifestHashalgo.appendChild(doc.createTextNode(Constant.DIGEST_ALGO));
        Element signatureType = doc.createElementNS("http://schemas.microsoft.com/office/2006/digsig", "SignatureType");
        signatureType.appendChild(doc.createTextNode("1"));
        Element sigInfoV1 = doc.createElementNS("http://schemas.microsoft.com/office/2006/digsig", "SignatureInfoV1");
        if (signingReason != null && !signingReason.equals("")) {
            sigInfoV1.appendChild(signatureComments);
        }
        sigInfoV1.appendChild(signatureType);
        sigInfoV1.appendChild(manifestHashalgo);
        Element sigProp = doc.createElementNS(Constant.W3C_XML_SIG_NS, "SignatureProperty");
        sigProp.setAttribute("Id", "idOfficeV1Details");
        sigProp.setAttribute("Target", "idPackageSignature");
        sigProp.appendChild(sigInfoV1);
        Element sigProps = doc.createElementNS(Constant.W3C_XML_SIG_NS, "SignatureProperties");
        sigProps.appendChild(sigProp);
        Element object = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Object");
        object.setAttribute("Id", "idOfficeObject");
        object.appendChild(sigProps);
        return object;
    }

    public static Element createIdOfficeObjectRef(org.w3c.dom.Document doc, Element idOfficeObject) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        ByteArrayOutputStream objectOut = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(idOfficeObject), new StreamResult(objectOut));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        canonicalizer.canonicalize(objectOut.toByteArray(), (OutputStream)out, false);
        byte[] canonXmlBytes = out.toByteArray();
        MessageDigest md = MessageDigest.getInstance(Constant.HASH_ALGO);
        md.update(canonXmlBytes);
        String digest = Base64.getEncoder().encodeToString(md.digest());
        Element digestMethod = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestMethod");
        digestMethod.setAttribute("Algorithm", Constant.DIGEST_ALGO);
        Element digestValue = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestValue");
        digestValue.appendChild(doc.createTextNode(digest));
        Element idOfficeObjectRef = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Reference");
        idOfficeObjectRef.setAttribute("URI", "#idOfficeObject");
        idOfficeObjectRef.setAttribute("Type", "http://www.w3.org/2000/09/xmldsig#Object");
        idOfficeObjectRef.appendChild(digestMethod);
        idOfficeObjectRef.appendChild(digestValue);
        return idOfficeObjectRef;
    }

    private Element createSignedProperties(org.w3c.dom.Document doc, List<X509Certificate> signerCertChain, String signingTime) throws Exception {
        MessageDigest md = MessageDigest.getInstance(Constant.HASH_ALGO);
        md.update(signerCertChain.get(0).getEncoded());
        String digest = Base64.getEncoder().encodeToString(md.digest());
        Element digestMethod = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestMethod");
        digestMethod.setAttribute("Algorithm", Constant.DIGEST_ALGO);
        Element digestValue = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestValue");
        digestValue.appendChild(doc.createTextNode(digest));
        Element certDigest = doc.createElementNS(Constant.XAdES_NS, "xd:CertDigest");
        certDigest.appendChild(digestMethod);
        certDigest.appendChild(digestValue);
        Element issuerName = doc.createElementNS(Constant.W3C_XML_SIG_NS, "X509IssuerName");
        issuerName.appendChild(doc.createTextNode(signerCertChain.get(0).getIssuerDN().getName()));
        Element serialNo = doc.createElementNS(Constant.W3C_XML_SIG_NS, "X509SerialNumber");
        serialNo.appendChild(doc.createTextNode(signerCertChain.get(0).getSerialNumber().toString()));
        Element issuerSerial = doc.createElementNS(Constant.XAdES_NS, "xd:IssuerSerial");
        issuerSerial.appendChild(issuerName);
        issuerSerial.appendChild(serialNo);
        Element cert = doc.createElementNS(Constant.XAdES_NS, "xd:Cert");
        cert.appendChild(certDigest);
        cert.appendChild(issuerSerial);
        Element signingCert = doc.createElementNS(Constant.XAdES_NS, "xd:SigningCertificate");
        signingCert.appendChild(cert);
        Element signaturePolicyImplied = doc.createElementNS(Constant.XAdES_NS, "xd:SignaturePolicyImplied");
        Element signaturePolicyIdentifier = doc.createElementNS(Constant.XAdES_NS, "xd:SignaturePolicyIdentifier");
        signaturePolicyIdentifier.appendChild(signaturePolicyImplied);
        Element sigTime = doc.createElementNS(Constant.XAdES_NS, "xd:SigningTime");
        sigTime.appendChild(doc.createTextNode(signingTime));
        Element signedSigProps = doc.createElementNS(Constant.XAdES_NS, "xd:SignedSignatureProperties");
        signedSigProps.appendChild(sigTime);
        signedSigProps.appendChild(signingCert);
        signedSigProps.appendChild(signaturePolicyIdentifier);
        Element signedProps = doc.createElementNS(Constant.XAdES_NS, "xd:SignedProperties");
        signedProps.setAttribute("Id", "idSignedProperties");
        signedProps.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", Constant.W3C_XML_SIG_NS);
        signedProps.appendChild(signedSigProps);
        return signedProps;
    }

    public static Element createSignedPropsObjectRef(org.w3c.dom.Document doc, List<X509Certificate> chain, Element signedProperties) throws Exception {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "yes");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", "UTF-8");
        ByteArrayOutputStream objectOut = new ByteArrayOutputStream();
        transformer.transform(new DOMSource(signedProperties), new StreamResult(objectOut));
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Canonicalizer canonicalizer = Canonicalizer.getInstance((String)"http://www.w3.org/TR/2001/REC-xml-c14n-20010315");
        canonicalizer.canonicalize(objectOut.toByteArray(), (OutputStream)out, false);
        byte[] canonXmlBytes = out.toByteArray();
        MessageDigest md = MessageDigest.getInstance(Constant.HASH_ALGO);
        md.update(canonXmlBytes);
        String digest = Base64.getEncoder().encodeToString(md.digest());
        Element digestMethod = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestMethod");
        digestMethod.setAttribute("Algorithm", Constant.DIGEST_ALGO);
        Element digestValue = doc.createElementNS(Constant.W3C_XML_SIG_NS, "DigestValue");
        digestValue.appendChild(doc.createTextNode(digest));
        Element trannformAlg = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Transform");
        trannformAlg.setAttribute("Algorithm", Constant.CAN_ALGO);
        Element transforms = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Transforms");
        transforms.appendChild(trannformAlg);
        Element signedPropsRef = doc.createElementNS(Constant.W3C_XML_SIG_NS, "Reference");
        signedPropsRef.setAttribute("URI", "#idSignedProperties");
        signedPropsRef.setAttribute("Type", "http://uri.etsi.org/01903#SignedProperties");
        signedPropsRef.appendChild(transforms);
        signedPropsRef.appendChild(digestMethod);
        signedPropsRef.appendChild(digestValue);
        return signedPropsRef;
    }

    private Element createKeyInfo(org.w3c.dom.Document doc, List<X509Certificate> signerCertChain) throws Exception {
        Element x509Data = doc.createElementNS(Constant.W3C_XML_SIG_NS, "X509Data");
        Element x509Cert = doc.createElementNS(Constant.W3C_XML_SIG_NS, "X509Certificate");
        x509Cert.appendChild(doc.createTextNode(Base64.getEncoder().encodeToString(signerCertChain.get(0).getEncoded())));
        x509Data.appendChild(x509Cert);
        Element keyInfo = doc.createElementNS(Constant.W3C_XML_SIG_NS, "KeyInfo");
        keyInfo.appendChild(x509Data);
        return keyInfo;
    }

    private Element createSignedInfo(org.w3c.dom.Document doc, Element idPackgObjectRef, Element idOfficeObjectRef, Element signedPropertiesRef) throws Exception {
        Element canMethod = doc.createElementNS(Constant.W3C_XML_SIG_NS, "CanonicalizationMethod");
        canMethod.setAttribute("Algorithm", Constant.CAN_ALGO);
        Element sigMethod = doc.createElementNS(Constant.W3C_XML_SIG_NS, "SignatureMethod");
        sigMethod.setAttribute("Algorithm", Constant.SIG_ALGO);
        Element signedInfo = doc.createElementNS(Constant.W3C_XML_SIG_NS, "SignedInfo");
        signedInfo.appendChild(canMethod);
        signedInfo.appendChild(sigMethod);
        signedInfo.appendChild(idPackgObjectRef);
        signedInfo.appendChild(idOfficeObjectRef);
        signedInfo.appendChild(signedPropertiesRef);
        return signedInfo;
    }
}

