/*
 * Decompiled with CFR 0.152.
 */
package com.ssl.doc.signing.tool.util;

import com.ssl.doc.signing.tool.exception.AccessTokenException;
import com.ssl.doc.signing.tool.http.HTTPClient;
import java.util.HashMap;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;

public class AccessToken {
    private String clientId;
    private String username;
    private String password;
    private String oaut2Endpoint;

    public AccessToken(String clientId, String username, String password, String oaut2Endpoint) {
        this.clientId = clientId;
        this.username = username;
        this.password = password;
        this.oaut2Endpoint = oaut2Endpoint;
    }

    public String getAccessToken() throws Exception {
        HashMap<String, String> reqHeaders = new HashMap<String, String>();
        reqHeaders.put("content-type", "application/json");
        JSONObject body = new JSONObject();
        body.put((Object)"client_id", (Object)this.clientId);
        body.put((Object)"grant_type", (Object)"password");
        body.put((Object)"username", (Object)this.username);
        body.put((Object)"password", (Object)this.password);
        HTTPClient client = new HTTPClient(this.oaut2Endpoint, reqHeaders);
        client.sendPOSTRequest(body.toJSONString().getBytes());
        JSONParser responseParser = new JSONParser();
        JSONObject responseJson = (JSONObject)responseParser.parse(new String(client.getBody()));
        if (client.getHttpStatus() != 200) {
            String errorDesc = (String)responseJson.get((Object)"error_description");
            throw new AccessTokenException(errorDesc);
        }
        return (String)responseJson.get((Object)"access_token");
    }
}

