/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.TreeMap;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.openxml4j.exceptions.InvalidFormatException;
import org.openxml4j.exceptions.InvalidOperationException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.PackageRelationship;
import org.openxml4j.opc.PackagingURIHelper;
import org.openxml4j.opc.TargetMode;

public final class PackageRelationshipCollection
implements Iterable<PackageRelationship> {
    private static Logger logger = LogManager.getLogger((String)"org.openxml4j.opc");
    private TreeMap<String, PackageRelationship> relationshipsByID = new TreeMap();
    private TreeMap<String, PackageRelationship> relationshipsByType = new TreeMap();
    private PackagePart relationshipPart;
    private PackagePart sourcePart;
    private PackagePartName partName;
    private Package container;

    PackageRelationshipCollection() {
    }

    public PackageRelationshipCollection(PackageRelationshipCollection coll, String filter) {
        this();
        for (PackageRelationship rel : coll.relationshipsByID.values()) {
            if (filter != null && !rel.getRelationshipType().equals(filter)) continue;
            this.addRelationship(rel);
        }
    }

    public PackageRelationshipCollection(Package container) throws InvalidFormatException {
        this(container, null);
    }

    public PackageRelationshipCollection(PackagePart part) throws InvalidFormatException {
        this(part.container, part);
    }

    public PackageRelationshipCollection(Package container, PackagePart part) throws InvalidFormatException {
        this();
        if (container == null) {
            throw new IllegalArgumentException("container");
        }
        if (part != null && part.isRelationshipPart()) {
            throw new IllegalArgumentException("part");
        }
        this.container = container;
        this.sourcePart = part;
        this.partName = PackageRelationshipCollection.getRelationshipPartName(part);
        if (container.getPackageAccess() != PackageAccess.WRITE && container.containPart(this.partName)) {
            this.relationshipPart = container.getPart(this.partName);
            this.parseRelationshipsPart(this.relationshipPart);
        }
    }

    private static PackagePartName getRelationshipPartName(PackagePart part) throws InvalidOperationException {
        PackagePartName partName = part == null ? PackagingURIHelper.PACKAGE_ROOT_PART_NAME : part.getPartName();
        return PackagingURIHelper.getRelationshipPartName(partName);
    }

    public void addRelationship(PackageRelationship relPart) {
        this.relationshipsByID.put(relPart.getId(), relPart);
        this.relationshipsByType.put(relPart.getRelationshipType(), relPart);
    }

    public PackageRelationship addRelationship(URI targetUri, TargetMode targetMode, String relationshipType, String id) {
        if (id == null) {
            int i = 0;
            while (this.relationshipsByID.get(id = "rId" + ++i) != null) {
            }
        }
        PackageRelationship rel = new PackageRelationship(this.container, this.sourcePart, targetUri, targetMode, relationshipType, id);
        this.relationshipsByID.put(rel.getId(), rel);
        this.relationshipsByType.put(rel.getRelationshipType(), rel);
        return rel;
    }

    public void removeRelationship(String id) {
        PackageRelationship rel;
        if (this.relationshipsByID != null && this.relationshipsByType != null && (rel = this.relationshipsByID.get(id)) != null) {
            this.relationshipsByID.remove(rel.getId());
            this.relationshipsByType.values().remove(rel);
        }
    }

    public void removeRelationship(PackageRelationship rel) {
        if (rel == null) {
            throw new IllegalArgumentException("rel");
        }
        this.relationshipsByID.values().remove(rel);
        this.relationshipsByType.values().remove(rel);
    }

    public PackageRelationship getRelationship(int index) {
        if (index < 0 || index > this.relationshipsByID.values().size()) {
            throw new IllegalArgumentException("index");
        }
        PackageRelationship retRel = null;
        int i = 0;
        for (PackageRelationship rel : this.relationshipsByID.values()) {
            if (index != i++) continue;
            return rel;
        }
        return retRel;
    }

    public PackageRelationship getRelationshipByID(String id) {
        return this.relationshipsByID.get(id);
    }

    public int size() {
        return this.relationshipsByID.values().size();
    }

    private void parseRelationshipsPart(PackagePart relPart) throws InvalidFormatException {
        try {
            SAXReader reader = new SAXReader();
            reader.setFeature("http://xml.org/sax/features/external-general-entities", false);
            reader.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            reader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            logger.debug("Parsing relationship: " + relPart.getPartName());
            Document xmlRelationshipsDoc = reader.read(relPart.getInputStream());
            Element root = xmlRelationshipsDoc.getRootElement();
            boolean fCorePropertiesRelationship = false;
            Iterator i = root.elementIterator("Relationship");
            while (i.hasNext()) {
                URI target;
                Element element = (Element)i.next();
                String id = element.attribute("Id").getValue();
                String type = element.attribute("Type").getValue();
                if (type.equals("http://schemas.openxmlformats.org/package/2006/relationships/metadata/core-properties")) {
                    if (!fCorePropertiesRelationship) {
                        fCorePropertiesRelationship = true;
                    } else {
                        throw new InvalidFormatException("OPC Compliance error [M4.1]: there is more than one core properties relationship in the package !");
                    }
                }
                Attribute targetModeAttr = element.attribute("TargetMode");
                TargetMode targetMode = TargetMode.INTERNAL;
                if (targetModeAttr != null) {
                    targetMode = targetModeAttr.getValue().toLowerCase().equals("internal") ? TargetMode.INTERNAL : TargetMode.EXTERNAL;
                }
                String value = "";
                try {
                    value = element.attribute("Target").getValue();
                    if (value.indexOf("\\") != -1) {
                        logger.info("target contains \\ therefore not a valid URI" + value + " replaced by /");
                        value = value.replaceAll("\\\\", "/");
                    }
                    target = new URI(value);
                }
                catch (URISyntaxException e) {
                    logger.error("Cannot convert " + value + " in a valid relationship URI-> ignored", (Throwable)e);
                    continue;
                }
                this.addRelationship(target, targetMode, type, id);
            }
        }
        catch (Exception e) {
            logger.error((Object)e);
            throw new InvalidFormatException(e.getMessage());
        }
    }

    public PackageRelationshipCollection getRelationships(String typeFilter) {
        PackageRelationshipCollection coll = new PackageRelationshipCollection(this, typeFilter);
        return coll;
    }

    @Override
    public Iterator<PackageRelationship> iterator() {
        return this.relationshipsByID.values().iterator();
    }

    public Iterator<PackageRelationship> iterator(String typeFilter) {
        ArrayList<PackageRelationship> retArr = new ArrayList<PackageRelationship>();
        for (PackageRelationship rel : this.relationshipsByID.values()) {
            if (!rel.getRelationshipType().equals(typeFilter)) continue;
            retArr.add(rel);
        }
        return retArr.iterator();
    }

    public void clear() {
        this.relationshipsByID.clear();
        this.relationshipsByType.clear();
    }

    public String toString() {
        String str = this.relationshipsByID == null ? "relationshipsByID=null" : this.relationshipsByID.size() + " relationship(s) = [";
        str = this.relationshipPart != null && this.relationshipPart.partName != null ? str + "," + this.relationshipPart.partName : str + ",relationshipPart=null";
        str = this.sourcePart != null && this.sourcePart.partName != null ? str + "," + this.sourcePart.partName : str + ",sourcePart=null";
        str = this.partName != null ? str + "," + this.partName : str + ",uri=null)";
        return str + "]";
    }
}

