/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc.internal;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import org.openxml4j.exceptions.InvalidFormatException;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.internal.ContentType;
import org.openxml4j.opc.internal.MemoryPackagePartOutputStream;
import org.openxml4j.opc.internal.marshallers.ZipPartMarshaller;

public final class MemoryPackagePart
extends PackagePart {
    protected byte[] data;
    protected int length;

    public MemoryPackagePart(Package pack, PackagePartName partName, String contentType) throws InvalidFormatException {
        super(pack, partName, contentType);
    }

    public MemoryPackagePart(Package pack, PackagePartName partName, String contentType, boolean loadRelationships) throws InvalidFormatException {
        super(pack, partName, new ContentType(contentType), loadRelationships);
    }

    @Override
    protected InputStream getInputStreamImpl() {
        if (this.data == null) {
            this.data = new byte[0];
        }
        return new ByteArrayInputStream(this.data);
    }

    @Override
    protected OutputStream getOutputStreamImpl() {
        return new MemoryPackagePartOutputStream(this);
    }

    public void clear() {
        this.data = null;
        this.length = 0;
    }

    @Override
    public boolean save(OutputStream os) throws OpenXML4JException {
        return new ZipPartMarshaller().marshall(this, os);
    }

    @Override
    public boolean load(InputStream ios) throws InvalidFormatException {
        throw new InvalidFormatException("Method not implemented");
    }

    @Override
    public void close() {
    }

    @Override
    public void flush() {
    }
}

