/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc.signature;

import java.security.Key;
import java.security.KeyException;
import java.security.PublicKey;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.AlgorithmMethod;
import javax.xml.crypto.KeySelector;
import javax.xml.crypto.KeySelectorException;
import javax.xml.crypto.KeySelectorResult;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.SignatureMethod;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import org.openxml4j.exceptions.InvalidFormatException;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackageRelationshipCollection;
import org.openxml4j.opc.PackagingURIHelper;
import org.openxml4j.opc.signature.PackageDigitalSignature;

public class OPCKeySelector
extends KeySelector
implements KeySelectorResult {
    private X509Certificate signingCertificate;
    private PackageDigitalSignature packageDigitalSignature;
    private PublicKey signingPublicKey;

    public OPCKeySelector(PackageDigitalSignature pPackageDigitalSignature) {
        this.packageDigitalSignature = pPackageDigitalSignature;
    }

    public X509Certificate getSigningCertificate() {
        return this.signingCertificate;
    }

    public PackageDigitalSignature getPackageDigitalSignature() {
        return this.packageDigitalSignature;
    }

    public PublicKey getSigningPublicKey() {
        return this.signingPublicKey;
    }

    @Override
    public KeySelectorResult select(KeyInfo keyInfo, KeySelector.Purpose purpose, AlgorithmMethod method, XMLCryptoContext context) throws KeySelectorException {
        SignatureMethod signatureMethod = (SignatureMethod)method;
        X509Certificate cert = null;
        cert = this.tryGetSigningCertificateFromX509Data(keyInfo, signatureMethod);
        if (cert != null) {
            this.signingCertificate = cert;
            this.signingPublicKey = cert.getPublicKey();
            return this;
        }
        cert = this.tryGetSigningCertificateFromCertificatePart(signatureMethod);
        if (cert != null) {
            this.signingCertificate = cert;
            this.signingPublicKey = cert.getPublicKey();
            return this;
        }
        PublicKey pKey = this.getPublicKeyFromKeyInfo(keyInfo, signatureMethod);
        if (pKey != null) {
            this.signingPublicKey = pKey;
            return this;
        }
        return null;
    }

    private PublicKey getPublicKeyFromKeyInfo(KeyInfo keyInfo, SignatureMethod method) throws KeySelectorException {
        for (XMLStructure o1 : keyInfo.getContent()) {
            PublicKey retVal;
            if (!(o1 instanceof KeyValue)) continue;
            KeyValue data = (KeyValue)o1;
            try {
                retVal = data.getPublicKey();
            }
            catch (KeyException e) {
                throw new KeySelectorException(e);
            }
            if (this.matchingAlgorithms(retVal.getAlgorithm(), method.getAlgorithm())) continue;
            throw new KeySelectorException("algorithm specified by public key found in KeyValue is not supported. Specified algorithm is : " + retVal.getAlgorithm());
        }
        return null;
    }

    private X509Certificate tryGetSigningCertificateFromX509Data(KeyInfo keyInfo, SignatureMethod method) throws KeySelectorException {
        ArrayList<X509Certificate> sortedCerts;
        ArrayList<X509Certificate> foundCerts = new ArrayList<X509Certificate>();
        for (XMLStructure o1 : keyInfo.getContent()) {
            if (!(o1 instanceof X509Data)) continue;
            X509Data data = (X509Data)o1;
            for (Object o2 : data.getContent()) {
                if (!(o2 instanceof X509Certificate)) continue;
                X509Certificate cert = (X509Certificate)o2;
                foundCerts.add(cert);
            }
        }
        if (foundCerts.size() == 0) {
            return null;
        }
        if (foundCerts.size() == 1) {
            X509Certificate cert = (X509Certificate)foundCerts.get(0);
            return cert;
        }
        try {
            sortedCerts = this.sortCerts(foundCerts);
        }
        catch (InvalidFormatException e) {
            throw new KeySelectorException(e);
        }
        X509Certificate cert = sortedCerts.get(0);
        return cert;
    }

    private X509Certificate tryGetSigningCertificateFromCertificatePart(SignatureMethod signatureMethod) throws KeySelectorException {
        PackageRelationshipCollection certRels = null;
        try {
            certRels = this.getPackageDigitalSignature().getSignaturePart().getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/certificate");
        }
        catch (InvalidFormatException e) {
            throw new KeySelectorException(e);
        }
        if (certRels != null && certRels.size() > 0) {
            if (certRels.size() == 1) {
                try {
                    CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
                    PackagePart certPart = null;
                    certPart = this.getPackageDigitalSignature().getSignaturePart().getPackage().getPart(PackagingURIHelper.createPartName(certRels.iterator().next().getTargetURI()));
                    X509Certificate cert = (X509Certificate)cf.generateCertificate(certPart.getInputStream());
                    if (!this.matchingAlgorithms(cert.getPublicKey().getAlgorithm(), signatureMethod.getAlgorithm())) {
                        throw new KeySelectorException("algorithm specified by signing certificate is not supported. Certificate specified algorithm is : " + cert.getPublicKey().getAlgorithm());
                    }
                    return cert;
                }
                catch (Exception e) {
                    throw new KeySelectorException(e);
                }
            }
            throw new KeySelectorException("multiple relationships found from signature part to certificate parts.");
        }
        return null;
    }

    private boolean matchingAlgorithms(String keyAlg, String signAlg) {
        if ("RSA".equalsIgnoreCase(keyAlg)) {
            return "http://www.w3.org/2000/09/xmldsig#rsa-sha1".equalsIgnoreCase(signAlg);
        }
        if ("DSA".equalsIgnoreCase(keyAlg)) {
            return "http://www.w3.org/2000/09/xmldsig#dsa-sha1".equalsIgnoreCase(signAlg);
        }
        if ("ECDSA".equalsIgnoreCase(keyAlg)) {
            return "http://www.w3.org/2001/04/xmldsig-more#ecdsa-sha1".equals(signAlg);
        }
        return false;
    }

    private ArrayList<X509Certificate> sortCerts(List<X509Certificate> icerts) throws InvalidFormatException {
        ArrayList<X509Certificate> retval = new ArrayList<X509Certificate>();
        X509Certificate currentCert = null;
        for (X509Certificate icert : icerts) {
            if (!icert.getIssuerDN().equals(icert.getSubjectDN())) continue;
            retval.add(0, icert);
            currentCert = icert;
            break;
        }
        icerts.remove(currentCert);
        if (retval.size() == 0) {
            throw new InvalidFormatException("Error in certificate chain, no root certificate found in chain");
        }
        int tries = 10;
        while (icerts.size() > 0 && tries > 0) {
            for (X509Certificate icert : icerts) {
                if (!currentCert.getSubjectDN().equals(icert.getIssuerDN())) continue;
                retval.add(0, icert);
                currentCert = icert;
                break;
            }
            icerts.remove(currentCert);
            if (--tries != 0) continue;
            throw new InvalidFormatException("Error constructing a complete ca certificate chain from retrieved certificates");
        }
        return retval;
    }

    @Override
    public Key getKey() {
        return this.getSigningPublicKey();
    }
}

