/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc.signature;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jcp.xml.dsig.internal.dom.DOMReference;
import org.openxml4j.exceptions.InvalidFormatException;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.PackagingURIHelper;
import org.openxml4j.opc.signature.OPCKeySelector;
import org.openxml4j.opc.signature.OPCSignatureHelper;
import org.openxml4j.opc.signature.OPCURIDereferencer;
import org.openxml4j.opc.signature.PackageDigitalSignatureManager;
import org.openxml4j.opc.signature.PackageRelationshipSelector;
import org.openxml4j.opc.signature.PackageRelationshipSelectorType;
import org.openxml4j.opc.signature.PartIdentifier;
import org.openxml4j.opc.signature.RelationshipIdentifier;
import org.openxml4j.opc.signature.RelationshipTransformProvider;
import org.openxml4j.opc.signature.VerifyResult;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class PackageDigitalSignature {
    protected PackageDigitalSignatureManager manager;
    protected PackagePart signaturePart;
    protected XMLSignature signature;
    protected X509Certificate signer;
    protected PublicKey signingPublicKey;
    protected boolean isSignatureValid;
    protected List<PartIdentifier> signedParts;
    protected List<PackageRelationshipSelector> signedRelationshipSelectors;
    protected String signingTimeStringValue;
    protected String timeFormat;
    public static String PackageObjectIdentifier = "idPackageObject";
    public static String SignatureTimeIdentifier = "idSignatureTime";
    public static String SignatureTimeElementName = "SignatureTime";
    public static String SignatureTimeFormatElementName = "Format";
    public static String SignatureTimeValueElementName = "Value";
    public static String DefaultSignatureId = "idPackageSignature";
    public static String OfficeObjectIdentifier = "idOfficeObject";
    protected boolean isVerified = false;

    public String getSigningTimeStringValue() throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        if (!this.isVerified) {
            this.Verify();
        }
        return this.signingTimeStringValue;
    }

    public String getTimeFormat() throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        if (!this.isVerified) {
            this.Verify();
        }
        return this.timeFormat;
    }

    public List<PartIdentifier> getSignedParts() throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        if (!this.isVerified) {
            this.Verify();
        }
        return this.signedParts;
    }

    public List<PackageRelationshipSelector> getSignedRelationshipSelectors() throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        if (!this.isVerified) {
            this.Verify();
        }
        return this.signedRelationshipSelectors;
    }

    public boolean getIsSignatureValid() throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        if (!this.isVerified) {
            this.Verify();
        }
        return this.isSignatureValid;
    }

    public XMLSignature getSignature() throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        if (!this.isVerified) {
            this.Verify();
        }
        return this.signature;
    }

    public PackagePart getSignaturePart() {
        return this.signaturePart;
    }

    public PackageDigitalSignatureManager getManager() {
        return this.manager;
    }

    public X509Certificate getSigner() throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        if (!this.isVerified) {
            this.Verify();
        }
        return this.signer;
    }

    public PublicKey getSigningPublicKey() throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        if (!this.isVerified) {
            this.Verify();
        }
        return this.signingPublicKey;
    }

    public byte[] getSignatureValue() throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        return this.getSignature().getSignatureValue().getValue();
    }

    public PackageDigitalSignature(PackageDigitalSignatureManager pManager, PackagePartName pPartName) throws InvalidFormatException, OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException {
        this.manager = pManager;
        this.signaturePart = pManager.getContainer().getPart(pPartName);
    }

    public VerifyResult Verify() throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        return this.verifySignatureAndFillProperties(null);
    }

    public VerifyResult Verify(X509Certificate pSigningCertificate) throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        if (pSigningCertificate == null) {
            throw new NullPointerException("Certificate can not be null");
        }
        return this.verifySignatureAndFillProperties(pSigningCertificate);
    }

    private VerifyResult verifySignatureAndFillProperties(X509Certificate pSigningCertificate) throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        DOMValidateContext dvc;
        this.isVerified = true;
        XMLSignatureFactory fac = OPCSignatureHelper.CreateXMLSignatureFactory();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        Document doc = dbf.newDocumentBuilder().parse(this.signaturePart.getInputStream());
        NodeList nl = doc.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", "Signature");
        if (nl.getLength() == 0) {
            throw new OpenXML4JException("Cannot find Signature element");
        }
        Node signatureNode = nl.item(0);
        if (pSigningCertificate == null) {
            OPCKeySelector keySelector = new OPCKeySelector(this);
            dvc = new DOMValidateContext(keySelector, signatureNode);
        } else {
            dvc = new DOMValidateContext(pSigningCertificate.getPublicKey(), signatureNode);
        }
        dvc.setProperty("org.jcp.xml.dsig.validateManifests", Boolean.TRUE);
        dvc.setURIDereferencer(new OPCURIDereferencer(this.getSignaturePart().getPackage(), fac.getURIDereferencer()));
        XMLSignature sig = fac.unmarshalXMLSignature(dvc);
        if (sig != null) {
            this.signature = sig;
        }
        this.isSignatureValid = sig.validate(dvc);
        if (this.isSignatureValid) {
            if (pSigningCertificate == null) {
                OPCKeySelector keySelector = (OPCKeySelector)sig.getKeySelectorResult();
                this.signer = keySelector.getSigningCertificate();
                this.signingPublicKey = keySelector.getSigningPublicKey();
            } else {
                this.signer = pSigningCertificate;
                this.signingPublicKey = pSigningCertificate.getPublicKey();
            }
        }
        this.fillSignedPartsAndRelationshipsAndTimeData(this.signature);
        if (this.isSignatureValid) {
            return VerifyResult.Success;
        }
        return VerifyResult.InvalidSignature;
    }

    private void fillSignedPartsAndRelationshipsAndTimeData(XMLSignature pSignature) throws OpenXML4JException {
        XMLObject idPackageObject = null;
        Manifest idPackageObjectManifest = null;
        SignatureProperties idPackageObjectSignatureProperties = null;
        for (XMLObject o : pSignature.getObjects()) {
            XMLObject xmlObj;
            if (!(o instanceof XMLObject) || !(xmlObj = o).getId().equalsIgnoreCase(PackageObjectIdentifier)) continue;
            if (idPackageObject != null) {
                throw new OpenXML4JException("found multiple package objects");
            }
            idPackageObject = xmlObj;
        }
        if (idPackageObject == null) {
            throw new OpenXML4JException(PackageObjectIdentifier + " not found.");
        }
        for (XMLStructure o1 : idPackageObject.getContent()) {
            System.out.println("M: " + o1.getClass());
            if (o1 instanceof Manifest) {
                System.out.println("Manifest");
                if (idPackageObjectManifest != null) {
                    throw new OpenXML4JException("multiple Manifest found in package object.");
                }
                idPackageObjectManifest = (Manifest)o1;
                continue;
            }
            if (o1 instanceof SignatureProperties) {
                System.out.println("SignatureProperties");
                if (idPackageObjectSignatureProperties != null) {
                    throw new OpenXML4JException("multiple SignatureProperties found in package object.");
                }
                idPackageObjectSignatureProperties = (SignatureProperties)o1;
                continue;
            }
            DOMStructure s = (DOMStructure)o1;
            try {
                Transformer transformer = TransformerFactory.newInstance().newTransformer();
                transformer.setOutputProperty("omit-xml-declaration", "yes");
                transformer.setOutputProperty("method", "xml");
                transformer.setOutputProperty("encoding", "UTF-8");
                ByteArrayOutputStream objectOut = new ByteArrayOutputStream();
                transformer.transform(new DOMSource(s.getNode()), new StreamResult(objectOut));
                System.out.println(new String(objectOut.toByteArray()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            throw new OpenXML4JException("package object contains element that is not manifest nor signatureproperties");
        }
        if (idPackageObjectManifest == null) {
            throw new OpenXML4JException("Manifest not found in package object");
        }
        if (idPackageObjectSignatureProperties == null) {
            throw new OpenXML4JException("SignatureProperties not found in package object");
        }
        this.fillSignedPartsAndRelationships(idPackageObjectManifest);
        this.fillTimeData(idPackageObjectSignatureProperties);
    }

    private void fillSignedPartsAndRelationships(Manifest pPackageObjectManifest) throws OpenXML4JException {
        for (Reference o : pPackageObjectManifest.getReferences()) {
            URI partURI = null;
            String contentType = null;
            PackagePart currentPart = null;
            Reference ref = o;
            if (!ref.getURI().startsWith("/")) {
                throw new OpenXML4JException("Reference inside Manifest of package object references to resource outside the package");
            }
            String[] splittedURI = ref.getURI().split("\\?");
            if (splittedURI.length != 2) {
                throw new OpenXML4JException("Reference inside Manifest of package object is not well formed. URI is : " + ref.getURI());
            }
            if (splittedURI[0].contains("#")) {
                throw new OpenXML4JException("Reference inside of package object can't contain fragment identifier. URI is : " + ref.getURI());
            }
            try {
                partURI = new URI(splittedURI[0]);
            }
            catch (URISyntaxException e) {
                throw new OpenXML4JException("package part URI specified in reference is not valid URI. URI is : " + ref.getURI());
            }
            String[] splittedContentTypePart = splittedURI[1].split("=");
            if (splittedContentTypePart.length != 2) {
                throw new OpenXML4JException("package part URI specified in reference does not have valid ContentType. URI is : " + ref.getURI());
            }
            if (!splittedContentTypePart[0].equalsIgnoreCase("ContentType")) {
                throw new OpenXML4JException("package part URI specified in reference does not have valid ContentType. URI is : " + ref.getURI());
            }
            contentType = splittedContentTypePart[1];
            currentPart = this.signaturePart.getPackage().getPart(PackagingURIHelper.createPartName(partURI));
            if (!currentPart.getContentType().equals(contentType)) {
                throw new OpenXML4JException("content type specified in reference does not match the actual content type of a part. Reference URI is : " + ref.getURI());
            }
            if (contentType.equals("application/vnd.openxmlformats-package.relationships+xml")) {
                boolean isRelationshipTransformFound = false;
                boolean isC14NTransformFound = false;
                for (Transform oT : ref.getTransforms()) {
                    Transform tran = oT;
                    if (tran.getAlgorithm().equalsIgnoreCase(RelationshipTransformProvider.RelationShipTransformAlgorithm)) {
                        if (isRelationshipTransformFound) {
                            throw new OpenXML4JException("Reference contains multiple relationship transforms for single part " + partURI.toString());
                        }
                        isRelationshipTransformFound = true;
                        continue;
                    }
                    if (tran.getAlgorithm().equalsIgnoreCase("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || tran.getAlgorithm().equalsIgnoreCase("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments") || tran.getAlgorithm().equalsIgnoreCase("http://www.w3.org/2001/10/xml-exc-c14n#") || tran.getAlgorithm().equalsIgnoreCase("http://www.w3.org/2001/10/xml-exc-c14n#WithComments")) {
                        isC14NTransformFound = true;
                        continue;
                    }
                    throw new OpenXML4JException("Reference element inside Manifest specifies transform that is not supported. Transform algorithm : " + tran.getAlgorithm());
                }
                if (isRelationshipTransformFound && !isC14NTransformFound) {
                    throw new OpenXML4JException("Reference contains Relationship transform not followed by c14n transform. Reference URI is : " + ref.getURI());
                }
                String sourceUriString = currentPart.getPartName().getName().replace("/_rels", "").replace(".rels", "");
                if (isRelationshipTransformFound) {
                    Attr refURIAttrNode = (Attr)((DOMReference)ref).getHere();
                    Element refElem = refURIAttrNode.getOwnerElement();
                    Element allTransforms = (Element)refElem.getFirstChild();
                    Element relTransfElem = (Element)allTransforms.getFirstChild();
                    NodeList transformparams = relTransfElem.getChildNodes();
                    if (transformparams == null || transformparams.getLength() == 0) {
                        throw new OpenXML4JException("Relationship transform specified , but no parameters given to relationship transform. Reference URI is : " + ref.getURI());
                    }
                    PackageRelationshipSelector pkgRelSel = null;
                    try {
                        pkgRelSel = new PackageRelationshipSelector(new URI(sourceUriString), currentPart.getPartName());
                    }
                    catch (URISyntaxException e) {
                        throw new OpenXML4JException("Relationship part name does not follow relationships part naming conventions. Relationship part name : " + currentPart.getPartName().toString());
                    }
                    for (int i = 0; i < transformparams.getLength(); ++i) {
                        RelationshipIdentifier relIdent = null;
                        Node tempNode = null;
                        NamedNodeMap nl = transformparams.item(i).getAttributes();
                        tempNode = nl.getNamedItem("SourceId");
                        if (tempNode != null) {
                            relIdent = new RelationshipIdentifier(PackageRelationshipSelectorType.Id, tempNode.getNodeValue());
                            pkgRelSel.addRelationshipIdentifier(relIdent);
                            continue;
                        }
                        tempNode = nl.getNamedItem("SourceType");
                        if (tempNode != null) {
                            relIdent = new RelationshipIdentifier(PackageRelationshipSelectorType.Type, tempNode.getNodeValue());
                            pkgRelSel.addRelationshipIdentifier(relIdent);
                            continue;
                        }
                        throw new OpenXML4JException("Relationship transform parameter found but neither SourceId nor SourceType is not specified.");
                    }
                    this.ensureSignedRelationshipSelectors();
                    this.signedRelationshipSelectors.add(pkgRelSel);
                    continue;
                }
                PackageRelationshipSelector pkgRelSel = null;
                try {
                    pkgRelSel = new PackageRelationshipSelector(new URI(sourceUriString), currentPart.getPartName(), true);
                }
                catch (URISyntaxException e) {
                    throw new OpenXML4JException("Relationship part name does not follow relationships part naming conventions. Relationship part name : " + currentPart.getPartName().toString());
                }
                this.ensureSignedRelationshipSelectors();
                this.signedRelationshipSelectors.add(pkgRelSel);
                continue;
            }
            PartIdentifier currentPartIdentifier = new PartIdentifier(partURI, contentType);
            this.ensureSignedParts();
            this.signedParts.add(currentPartIdentifier);
        }
    }

    private void fillTimeData(SignatureProperties pPackageSignatureProperties) throws OpenXML4JException {
        SignatureProperty idSignatureTimeProperty = null;
        Node signatureTimeNode = null;
        List<SignatureProperty> propList = pPackageSignatureProperties.getProperties();
        for (SignatureProperty o : propList) {
            SignatureProperty sigProp = o;
            if (!sigProp.getId().equalsIgnoreCase(SignatureTimeIdentifier)) continue;
            idSignatureTimeProperty = sigProp;
            break;
        }
        if (idSignatureTimeProperty == null) {
            throw new OpenXML4JException("SignatureProperties does not contain SignatureProperty with id : " + SignatureTimeIdentifier);
        }
        if (!idSignatureTimeProperty.getTarget().equals("") && !idSignatureTimeProperty.getTarget().equalsIgnoreCase("#" + this.signature.getId())) {
            throw new OpenXML4JException("Target attribute of Signature Time Property should be either empty or contain a fragment reference to the value of id attribute of the root Signature Element. Found target is : " + idSignatureTimeProperty.getTarget());
        }
        if (idSignatureTimeProperty.getContent().size() != 1) {
            throw new OpenXML4JException("Signature Time Property should contain exactly one SignatureTime child element. Multiple child elements foind for signature property");
        }
        signatureTimeNode = ((DOMStructure)idSignatureTimeProperty.getContent().get(0)).getNode();
        if (!signatureTimeNode.getLocalName().equalsIgnoreCase(SignatureTimeElementName)) {
            throw new OpenXML4JException("Signature Time Property should contain exactly one SignatureTime child element. SignatureTime element not found as a child to property");
        }
        for (int i = 0; i < signatureTimeNode.getChildNodes().getLength(); ++i) {
            Node tempNode = signatureTimeNode.getChildNodes().item(i);
            if (tempNode.getLocalName().equalsIgnoreCase(SignatureTimeFormatElementName)) {
                this.timeFormat = tempNode.getTextContent();
            }
            if (!tempNode.getLocalName().equalsIgnoreCase(SignatureTimeValueElementName)) continue;
            this.signingTimeStringValue = tempNode.getTextContent();
        }
    }

    private void ensureSignedParts() {
        if (this.signedParts == null) {
            this.signedParts = new ArrayList<PartIdentifier>();
        }
    }

    private void ensureSignedRelationshipSelectors() {
        if (this.signedRelationshipSelectors == null) {
            this.signedRelationshipSelectors = new ArrayList<PackageRelationshipSelector>();
        }
    }

    static {
        RelationshipTransformProvider.InstallProvider();
        OPCSignatureHelper.InstallBouncyCastleProvider();
    }
}

