/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc.signature;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.net.URI;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyException;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.TimeZone;
import java.util.UUID;
import java.util.Vector;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.CanonicalizationMethod;
import javax.xml.crypto.dsig.Manifest;
import javax.xml.crypto.dsig.Reference;
import javax.xml.crypto.dsig.SignatureProperties;
import javax.xml.crypto.dsig.SignatureProperty;
import javax.xml.crypto.dsig.SignedInfo;
import javax.xml.crypto.dsig.Transform;
import javax.xml.crypto.dsig.XMLObject;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureException;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMSignContext;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyInfoFactory;
import javax.xml.crypto.dsig.keyinfo.KeyValue;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.crypto.dsig.spec.C14NMethodParameterSpec;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.openxml4j.exceptions.InvalidFormatException;
import org.openxml4j.exceptions.InvalidOperationException;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.exceptions.OpenXML4JRuntimeException;
import org.openxml4j.opc.CertificateEmbeddingOption;
import org.openxml4j.opc.Package;
import org.openxml4j.opc.PackageAccess;
import org.openxml4j.opc.PackagePart;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.PackageRelationship;
import org.openxml4j.opc.PackageRelationshipCollection;
import org.openxml4j.opc.PackagingURIHelper;
import org.openxml4j.opc.TargetMode;
import org.openxml4j.opc.signature.OPCSignatureHelper;
import org.openxml4j.opc.signature.OPCURIDereferencer;
import org.openxml4j.opc.signature.PackageDigitalSignature;
import org.openxml4j.opc.signature.PackageRelationshipSelector;
import org.openxml4j.opc.signature.PackageRelationshipSelectorType;
import org.openxml4j.opc.signature.PartIdentifier;
import org.openxml4j.opc.signature.RelationshipIdentifier;
import org.openxml4j.opc.signature.RelationshipTransformParameterSpec;
import org.openxml4j.opc.signature.RelationshipTransformProvider;
import org.openxml4j.opc.signature.VerifyResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class PackageDigitalSignatureManager {
    private static final String defaultOriginPartURL = "/_xmlsignatures/origin.sigs";
    private static final PackagePartName defaultOriginPartName;
    private static final String defaultHashAlgorithm = "http://www.w3.org/2000/09/xmldsig#sha1";
    private CertificateEmbeddingOption embeddingOption;
    private Package _container;
    private boolean originPartSearchDone = false;
    private PackagePart originPart;
    private boolean signaturesSearchDone = false;
    private List<PackageDigitalSignature> signatures;

    public Package getContainer() {
        return this._container;
    }

    public static String getDefaultHashAlgorithm() {
        return defaultHashAlgorithm;
    }

    public static PackagePartName getDefaultOriginPartName() {
        return defaultOriginPartName;
    }

    public CertificateEmbeddingOption getEmbeddingOption() {
        return this.embeddingOption;
    }

    public void setEmbeddingOption(CertificateEmbeddingOption embeddingOption) {
        if (embeddingOption != CertificateEmbeddingOption.IN_SIGNATURE_PART) {
            throw new InvalidOperationException("Only IN_SIGNATURE_PART Certificate Embedding Option is supported.");
        }
        this.embeddingOption = embeddingOption;
    }

    public PackageDigitalSignatureManager(Package pContainer) {
        this._container = pContainer;
    }

    public boolean getIsSigned() throws OpenXML4JException {
        return this.getSignatures() != null;
    }

    public List<PackageDigitalSignature> getSignatures() throws OpenXML4JException {
        if (this.getOriginPart() == null) {
            this.signatures = null;
            return null;
        }
        if (this.signaturesSearchDone) {
            return this.signatures;
        }
        this.signaturesSearchDone = true;
        for (PackageRelationship rel : this.originPart.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature")) {
            if (rel.getTargetMode() != null && rel.getTargetMode() != TargetMode.INTERNAL) {
                throw new OpenXML4JException("TargetMode attribute of relationship pointing to Digital Signature Signature part MUST be INTERNAL");
            }
            try {
                PackageDigitalSignature sig = new PackageDigitalSignature(this, PackagingURIHelper.createPartName(rel.getTargetURI()));
                this.ensureSignatures();
                this.signatures.add(sig);
            }
            catch (Exception e) {
                throw new OpenXML4JException(e);
            }
        }
        return this.signatures;
    }

    public PackagePart getOriginPart() throws OpenXML4JException {
        if (this.originPartSearchDone) {
            return this.originPart;
        }
        this.originPartSearchDone = true;
        PackageRelationship originPartRel = null;
        PackageRelationshipCollection dsigOriginPartTypeRelationships = this._container.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        if (dsigOriginPartTypeRelationships == null || dsigOriginPartTypeRelationships.size() == 0) {
            originPartRel = null;
            this.originPart = null;
        } else if (dsigOriginPartTypeRelationships.size() > 0) {
            for (PackageRelationship rel : this._container.getRelationshipsByType("http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin")) {
                if (originPartRel == null) {
                    originPartRel = rel;
                    continue;
                }
                if (originPartRel.getTargetURI().equals(rel.getTargetURI())) continue;
                throw new OpenXML4JException(" [M6.1] There are multiple relationships with DIGITAL_SIGNATURE_ORIGIN type pointing to multiple digital signature origin parts. There can be only one Digital Signature Origin Part in a package");
            }
        } else {
            originPartRel = dsigOriginPartTypeRelationships.iterator().next();
        }
        if (originPartRel != null) {
            if (originPartRel.getTargetMode() != null && originPartRel.getTargetMode() != TargetMode.INTERNAL) {
                throw new InvalidFormatException("TargetMode attribute of relationship pointing to Digital Signature Origin part MUST be INTERNAL");
            }
            this.originPart = this._container.getPart(PackagingURIHelper.createPartName(originPartRel.getTargetURI()));
        }
        return this.originPart;
    }

    public VerifyResult VerifySignatures() throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        for (PackageDigitalSignature sig : this.getSignatures()) {
            VerifyResult res = sig.Verify();
            if (res == VerifyResult.Success) continue;
            return res;
        }
        return VerifyResult.Success;
    }

    public VerifyResult VerifySignatures(X509Certificate pSigningCertificate) throws OpenXML4JException, SAXException, IOException, ParserConfigurationException, MarshalException, XMLSignatureException {
        if (pSigningCertificate == null) {
            throw new NullPointerException("Certificate can not be null");
        }
        for (PackageDigitalSignature sig : this.getSignatures()) {
            VerifyResult res = sig.Verify(pSigningCertificate);
            if (res == VerifyResult.Success) continue;
            return res;
        }
        return VerifyResult.Success;
    }

    public void SignDocument(PrivateKey pSigningPrivateKey, X509Certificate pSigningCertificate) throws OpenXML4JException {
        this.SignDocumentAllSignableItems(pSigningPrivateKey, pSigningCertificate);
    }

    private void ensureSignatures() {
        if (this.signatures == null) {
            this.signatures = new ArrayList<PackageDigitalSignature>();
        }
    }

    private PackagePart ensureOriginPart() throws OpenXML4JException {
        if (this.getOriginPart() != null) {
            return this.getOriginPart();
        }
        PackagePart digSigOriginPart = this._container.createPart(defaultOriginPartName, "application/vnd.openxmlformats-package.digital-signature-origin");
        this._container.addRelationship(digSigOriginPart.getPartName(), TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/origin");
        this.originPart = digSigOriginPart;
        this.originPartSearchDone = true;
        return this.originPart;
    }

    private PackagePart CreateDigitalSignatureSignaturePartFromContent(ByteArrayOutputStream pContent) throws OpenXML4JException {
        this.ensureOriginPart();
        UUID uuid = UUID.randomUUID();
        String signaturePartURI = "/_xmlsignatures/" + uuid.toString() + ".xml";
        PackagePart digitalSignatureSignaturePart = this._container.createPart(PackagingURIHelper.createPartName(signaturePartURI), "application/vnd.openxmlformats-package.digital-signature-xmlsignature+xml", pContent);
        this.originPart.addRelationship(digitalSignatureSignaturePart.getPartName(), TargetMode.INTERNAL, "http://schemas.openxmlformats.org/package/2006/relationships/digital-signature/signature");
        return digitalSignatureSignaturePart;
    }

    private void SetPartsAndRelationshipsToSign(List<PartIdentifier> opPartsToSign, List<PackageRelationshipSelector> opRelationshipsToSign) throws Exception {
        opPartsToSign.clear();
        opRelationshipsToSign.clear();
        PackageRelationshipCollection coreDocRelationships = this._container.getRelationshipsByType("http://schemas.openxmlformats.org/officeDocument/2006/relationships/officeDocument");
        for (PackageRelationship relationship : coreDocRelationships) {
            this.RecursivelyAddSignableItems(relationship, opPartsToSign, opRelationshipsToSign);
        }
    }

    private void RecursivelyAddSignableItems(PackageRelationship pRelationship, List<PartIdentifier> opPartsToSign, List<PackageRelationshipSelector> opRelationshipsToSign) throws Exception {
        PackagePart part;
        URI partURI;
        PartIdentifier tempPartIdent;
        PackagePartName relationshipPartName = null;
        relationshipPartName = pRelationship.getSourceURI().toString() != PackagingURIHelper.getPackageRootUri().toString() ? PackagingURIHelper.getRelationshipPartName(PackagingURIHelper.createPartName(pRelationship.getSourceURI())) : PackagingURIHelper.createPartName(pRelationship.getContainerPartRelationship());
        PackageRelationshipSelector selector = null;
        for (PackageRelationshipSelector prs : opRelationshipsToSign) {
            if (!prs.getRelationshipPartName().getName().equals(relationshipPartName.getName())) continue;
            selector = prs;
            break;
        }
        if (selector == null) {
            selector = new PackageRelationshipSelector(pRelationship.getSourceURI(), relationshipPartName);
            opRelationshipsToSign.add(selector);
        }
        selector.addRelationshipIdentifier(PackageRelationshipSelectorType.Id, pRelationship.getId());
        if (pRelationship.getTargetMode() == TargetMode.INTERNAL && !opPartsToSign.contains(tempPartIdent = new PartIdentifier(partURI = PackagingURIHelper.getURIFromPath((part = pRelationship.getPackage().getPart(PackagingURIHelper.createPartName(PackagingURIHelper.resolvePartUri(pRelationship.getSourceURI(), pRelationship.getTargetURI())))).getPartName().getName()), part.getContentType()))) {
            opPartsToSign.add(tempPartIdent);
            for (PackageRelationship childRel : part.getRelationships()) {
                this.RecursivelyAddSignableItems(childRel, opPartsToSign, opRelationshipsToSign);
            }
        }
    }

    private XMLObject CreateIdPackageObject(XMLSignatureFactory fac, String pSignatureId, Document pSignatureDoc, List<Reference> denManifestReferences) throws Exception {
        Vector<PartIdentifier> partsToSign = new Vector<PartIdentifier>();
        Vector<PackageRelationshipSelector> relationshipsToSign = new Vector<PackageRelationshipSelector>();
        this.SetPartsAndRelationshipsToSign(partsToSign, relationshipsToSign);
        Vector<Reference> manifestReferences = new Vector<Reference>();
        CanonicalizationMethod cm = fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null);
        for (PackageRelationshipSelector relSel : relationshipsToSign) {
            System.out.println("relSel: " + relSel.getRelationshipPartName().getName());
            Vector<String> relationShipIdsToInclude = new Vector<String>();
            for (RelationshipIdentifier relIdentifier : relSel.getRelationshipIdentifiers()) {
                relationShipIdsToInclude.add(relIdentifier.getSelectionCriteria());
            }
            RelationshipTransformParameterSpec relTransformParams = new RelationshipTransformParameterSpec(relationShipIdsToInclude, null);
            Transform relationShipTransform = fac.newTransform(RelationshipTransformProvider.RelationShipTransformAlgorithm, relTransformParams);
            Vector<Transform> transforms = new Vector<Transform>();
            transforms.add(relationShipTransform);
            transforms.add(cm);
            Reference refRel = fac.newReference(relSel.getRelationshipPartName().toString() + "?ContentType=" + "application/vnd.openxmlformats-package.relationships+xml", fac.newDigestMethod(defaultHashAlgorithm, null), transforms, null, null);
            manifestReferences.add(refRel);
        }
        for (PartIdentifier relPart : partsToSign) {
            System.out.println("relPart: " + relPart.getPartURI());
            Reference refPart = fac.newReference(relPart.getPartURI().toString() + "?ContentType=" + relPart.getContentType(), fac.newDigestMethod(defaultHashAlgorithm, null), null, null, null);
            manifestReferences.add(refPart);
        }
        Manifest manifestIdPackageObject = null;
        manifestIdPackageObject = denManifestReferences == null ? fac.newManifest(manifestReferences) : fac.newManifest(denManifestReferences);
        SignatureProperties signatureProperties = this.createSignaturePropertiesForIdPackageObject(fac, pSignatureId, pSignatureDoc);
        ArrayList<XMLStructure> idPackageObjectContent = new ArrayList<XMLStructure>();
        idPackageObjectContent.add(manifestIdPackageObject);
        idPackageObjectContent.add(signatureProperties);
        XMLObject idPackageObject = fac.newXMLObject(idPackageObjectContent, PackageDigitalSignature.PackageObjectIdentifier, null, null);
        return idPackageObject;
    }

    private SignatureProperties createSignaturePropertiesForIdPackageObject(XMLSignatureFactory fac, String pSignatureId, Document pSignatureDoc) {
        Calendar now = Calendar.getInstance(TimeZone.getTimeZone("GMT"));
        Date signingTime = now.getTime();
        String signatureDateTimeFormatString = "yyyy-MM-dd'T'HH:mm:ss";
        SimpleDateFormat sdf = new SimpleDateFormat(signatureDateTimeFormatString);
        sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
        String dateFriendly = sdf.format(signingTime);
        dateFriendly = dateFriendly + "Z";
        signatureDateTimeFormatString = "YYYY-MM-DDThh:mm:ssTZD";
        Element signDateTimeElement = pSignatureDoc.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", PackageDigitalSignature.SignatureTimeElementName);
        signDateTimeElement.setPrefix("mdssi");
        signDateTimeElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        Element signDateTimeFormat = pSignatureDoc.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", PackageDigitalSignature.SignatureTimeFormatElementName);
        signDateTimeFormat.setPrefix("mdssi");
        signDateTimeFormat.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        signDateTimeFormat.appendChild(pSignatureDoc.createTextNode(signatureDateTimeFormatString));
        Element signDateTimeValue = pSignatureDoc.createElementNS("http://schemas.openxmlformats.org/package/2006/digital-signature", PackageDigitalSignature.SignatureTimeValueElementName);
        signDateTimeValue.setPrefix("mdssi");
        signDateTimeValue.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
        signDateTimeValue.appendChild(pSignatureDoc.createTextNode(dateFriendly));
        signDateTimeElement.appendChild(signDateTimeFormat);
        signDateTimeElement.appendChild(signDateTimeValue);
        ArrayList<DOMStructure> signaturePropertiesElems = new ArrayList<DOMStructure>();
        signaturePropertiesElems.add(new DOMStructure(signDateTimeElement));
        SignatureProperty signatureProperty = fac.newSignatureProperty(signaturePropertiesElems, "#" + pSignatureId, PackageDigitalSignature.SignatureTimeIdentifier);
        SignatureProperties signatureProperties = fac.newSignatureProperties(Collections.singletonList(signatureProperty), null);
        return signatureProperties;
    }

    private XMLObject CreateIdOfficeObject(XMLSignatureFactory fac, String pSignatureId, Document pSignatureDoc) {
        Element signatureInfoV1 = pSignatureDoc.createElementNS("http://schemas.microsoft.com/office/2006/digsig", "SignatureInfoV1");
        signatureInfoV1.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "http://schemas.microsoft.com/office/2006/digsig");
        Element manifestHashAlgorithm = pSignatureDoc.createElement("ManifestHashAlgorithm");
        manifestHashAlgorithm.appendChild(pSignatureDoc.createTextNode(defaultHashAlgorithm));
        signatureInfoV1.appendChild(manifestHashAlgorithm);
        ArrayList<DOMStructure> signaturePropertiesElems = new ArrayList<DOMStructure>();
        signaturePropertiesElems.add(new DOMStructure(signatureInfoV1));
        SignatureProperty signatureProperty = fac.newSignatureProperty(signaturePropertiesElems, "#" + pSignatureId, "idOfficeV1Details");
        SignatureProperties signatureProperties = fac.newSignatureProperties(Collections.singletonList(signatureProperty), null);
        XMLObject idOfficeObject = fac.newXMLObject(Collections.singletonList(signatureProperties), "idOfficeObject", null, null);
        return idOfficeObject;
    }

    private List<Reference> CalculateIdPackageObjectReferences(PrivateKey pSigningPrivateKey, X509Certificate pSigningCertificate) throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
        dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        Document doc = dbf.newDocumentBuilder().newDocument();
        XMLSignatureFactory fac = OPCSignatureHelper.CreateXMLSignatureFactory();
        XMLObject idPackageObject = this.CreateIdPackageObject(fac, PackageDigitalSignature.DefaultSignatureId, doc, null);
        List<Reference> signedInfoReferences = ((Manifest)idPackageObject.getContent().get(0)).getReferences();
        SignedInfo si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), signedInfoReferences);
        KeyInfo ki = null;
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        KeyValue kv = kif.newKeyValue(pSigningCertificate.getPublicKey());
        X509Data x509d = kif.newX509Data(Collections.singletonList(pSigningCertificate));
        Vector<XMLStructure> keyInfoContents = new Vector<XMLStructure>();
        keyInfoContents.add(kv);
        keyInfoContents.add(x509d);
        ki = kif.newKeyInfo(keyInfoContents);
        XMLSignature signature = fac.newXMLSignature(si, ki, null, PackageDigitalSignature.DefaultSignatureId, null);
        DOMSignContext dsc = new DOMSignContext(pSigningPrivateKey, (Node)doc);
        dsc.setURIDereferencer(new OPCURIDereferencer(this._container, fac.getURIDereferencer()));
        signature.sign(dsc);
        return signature.getSignedInfo().getReferences();
    }

    private void SignDocumentAllSignableItems(PrivateKey pSigningPrivateKey, X509Certificate pSigningCertificate) throws OpenXML4JException {
        Transformer trans;
        KeyValue kv;
        SignedInfo si;
        XMLObject idPackageObject;
        Reference refIdOfficeObject;
        Reference refIdPackageObject;
        Document doc;
        if (this._container.getPackageAccess() != PackageAccess.READ_WRITE) {
            throw new OpenXML4JException("To sign a document package must be open with read write package access");
        }
        ByteArrayOutputStream boutTemp = new ByteArrayOutputStream();
        try {
            this._container.save(boutTemp);
        }
        catch (IOException e) {
            throw new OpenXML4JException("Error saving pre-formatted data to output", e);
        }
        ByteArrayInputStream binTemp = new ByteArrayInputStream(boutTemp.toByteArray());
        try {
            this._container = Package.open(binTemp, PackageAccess.READ_WRITE);
        }
        catch (InvalidFormatException e) {
            throw new OpenXML4JException("Pre-formatted data is not in valid openxml package format", e);
        }
        catch (IOException e) {
            throw new OpenXML4JException("Error opening pre-formatted data", e);
        }
        this.ensureOriginPart();
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        try {
            dbf.setFeature("http://xml.org/sax/features/external-general-entities", false);
            dbf.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            dbf.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            doc = dbf.newDocumentBuilder().newDocument();
        }
        catch (ParserConfigurationException e) {
            throw new OpenXML4JException("Document parsing error", e);
        }
        XMLSignatureFactory fac = OPCSignatureHelper.CreateXMLSignatureFactory();
        Vector<Reference> signedInfoReferences = new Vector<Reference>();
        try {
            refIdPackageObject = fac.newReference("#" + PackageDigitalSignature.PackageObjectIdentifier, fac.newDigestMethod(defaultHashAlgorithm, null), null, "http://www.w3.org/2000/09/xmldsig#Object", null);
            refIdOfficeObject = fac.newReference("#" + PackageDigitalSignature.OfficeObjectIdentifier, fac.newDigestMethod(defaultHashAlgorithm, null), null, "http://www.w3.org/2000/09/xmldsig#Object", null);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OpenXML4JException("XML signing algorithm error", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new OpenXML4JException("XML signing algorithm parameters error", e);
        }
        signedInfoReferences.add(refIdPackageObject);
        signedInfoReferences.add(refIdOfficeObject);
        Vector<XMLObject> signatureObjects = new Vector<XMLObject>();
        try {
            idPackageObject = this.CreateIdPackageObject(fac, PackageDigitalSignature.DefaultSignatureId, doc, this.CalculateIdPackageObjectReferences(pSigningPrivateKey, pSigningCertificate));
        }
        catch (Exception e) {
            throw new OpenXML4JException("Error constructing idPackageObject", e);
        }
        XMLObject idOfficeObject = this.CreateIdOfficeObject(fac, PackageDigitalSignature.DefaultSignatureId, doc);
        signatureObjects.add(idPackageObject);
        signatureObjects.add(idOfficeObject);
        try {
            si = fac.newSignedInfo(fac.newCanonicalizationMethod("http://www.w3.org/TR/2001/REC-xml-c14n-20010315", (C14NMethodParameterSpec)null), fac.newSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1", null), signedInfoReferences);
        }
        catch (NoSuchAlgorithmException e) {
            throw new OpenXML4JException("XML signing algorithm error", e);
        }
        catch (InvalidAlgorithmParameterException e) {
            throw new OpenXML4JException("XML signing algorithm parameters error", e);
        }
        KeyInfo ki = null;
        KeyInfoFactory kif = fac.getKeyInfoFactory();
        try {
            kv = kif.newKeyValue(pSigningCertificate.getPublicKey());
        }
        catch (KeyException e) {
            throw new OpenXML4JException("Problem obtaining public key from certificate", e);
        }
        X509Data x509d = kif.newX509Data(Collections.singletonList(pSigningCertificate));
        Vector<XMLStructure> keyInfoContents = new Vector<XMLStructure>();
        keyInfoContents.add(kv);
        keyInfoContents.add(x509d);
        ki = kif.newKeyInfo(keyInfoContents);
        XMLSignature signature = fac.newXMLSignature(si, ki, signatureObjects, PackageDigitalSignature.DefaultSignatureId, null);
        DOMSignContext dsc = new DOMSignContext(pSigningPrivateKey, (Node)doc);
        dsc.setURIDereferencer(new OPCURIDereferencer(this._container, fac.getURIDereferencer()));
        try {
            signature.sign(dsc);
        }
        catch (MarshalException e) {
            throw new OpenXML4JException("Error signing XML", e);
        }
        catch (XMLSignatureException e) {
            throw new OpenXML4JException("XMLSignature Exception when signing", e);
        }
        TransformerFactory tf = TransformerFactory.newInstance();
        try {
            trans = tf.newTransformer();
        }
        catch (TransformerConfigurationException e) {
            throw new OpenXML4JException("Problem creating Transformer for output", e);
        }
        trans.setOutputProperty("indent", "no");
        trans.setOutputProperty("standalone", "yes");
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        try {
            trans.transform(new DOMSource(doc), new StreamResult(bout));
        }
        catch (TransformerException e) {
            throw new OpenXML4JException("Problem transforming output to output stream", e);
        }
        this.CreateDigitalSignatureSignaturePartFromContent(bout);
    }

    static {
        try {
            RelationshipTransformProvider.InstallProvider();
            defaultOriginPartName = PackagingURIHelper.createPartName(defaultOriginPartURL);
            OPCSignatureHelper.InstallBouncyCastleProvider();
        }
        catch (InvalidFormatException e) {
            throw new OpenXML4JRuntimeException("");
        }
    }
}

