/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc.signature;

import java.net.URI;
import java.util.List;
import java.util.Vector;
import org.openxml4j.exceptions.InvalidFormatException;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.PackagePartName;
import org.openxml4j.opc.signature.PackageRelationshipSelectorType;
import org.openxml4j.opc.signature.RelationshipIdentifier;

public class PackageRelationshipSelector {
    protected URI sourceURI;
    protected PackagePartName relationshipPartName;
    protected List<RelationshipIdentifier> relationshipIdentifiers;
    protected boolean isAllRelationshipsIncluded;

    public URI getSourceURI() {
        return this.sourceURI;
    }

    public boolean getIsAllRelationshipsIncluded() {
        return this.isAllRelationshipsIncluded;
    }

    public PackagePartName getRelationshipPartName() throws InvalidFormatException {
        return this.relationshipPartName;
    }

    public List<RelationshipIdentifier> getRelationshipIdentifiers() {
        if (this.isAllRelationshipsIncluded) {
            return null;
        }
        return this.relationshipIdentifiers;
    }

    public void addRelationshipIdentifier(RelationshipIdentifier pRelationshipIdentifier) throws OpenXML4JException {
        if (this.isAllRelationshipsIncluded) {
            throw new OpenXML4JException("All relationships for relationship part : " + this.relationshipPartName.toString() + " are set to be included. Cannot add relationship identifier");
        }
        for (RelationshipIdentifier tempRelId : this.relationshipIdentifiers) {
            if (!tempRelId.selectionCriteria.equals(pRelationshipIdentifier.selectionCriteria) || !tempRelId.selectorType.equals((Object)pRelationshipIdentifier.selectorType)) continue;
            throw new OpenXML4JException("Relationship Identifier already added. Relationship Identifier to add: " + pRelationshipIdentifier);
        }
        this.relationshipIdentifiers.add(pRelationshipIdentifier);
    }

    public RelationshipIdentifier addRelationshipIdentifier(PackageRelationshipSelectorType pSelectorType, String pSelectionCriteria) throws Exception {
        RelationshipIdentifier relIdentifier = new RelationshipIdentifier(pSelectorType, pSelectionCriteria);
        this.addRelationshipIdentifier(relIdentifier);
        return relIdentifier;
    }

    public PackageRelationshipSelector(URI pSourceURI, PackagePartName pRelationshipPartName) {
        this(pSourceURI, pRelationshipPartName, false);
    }

    public PackageRelationshipSelector(URI pSourceURI, PackagePartName pRelationshipPartName, boolean pIsAllRelationshipsIncluded) {
        this.sourceURI = pSourceURI;
        this.relationshipPartName = pRelationshipPartName;
        this.relationshipIdentifiers = new Vector<RelationshipIdentifier>();
        this.isAllRelationshipsIncluded = pIsAllRelationshipsIncluded;
    }
}

