/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc.signature;

import java.util.HashMap;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.Node;
import org.dom4j.QName;
import org.dom4j.XPath;

public class RelationshipTransform {
    public static Document DoRelationshipTransform(Document docIn, List<String> pRelationshipIds, List<String> pRelationshipTypes) throws Exception {
        Document doc = (Document)docIn.clone();
        RelationshipTransform.RemoveProcessingInstructions(doc);
        RelationshipTransform.RemoveAllNameSpacesExceptRelationship(doc);
        RelationshipTransform.SortRelationshipElementsById(doc);
        RelationshipTransform.FilterRelationshipsByTypeAndId(doc, pRelationshipIds, pRelationshipTypes);
        RelationshipTransform.RemoveContentsFromRelationshipElements(doc);
        RelationshipTransform.RemoveAllTopLevelComments(doc);
        RelationshipTransform.AddTargetModeInternalAttributeIfMissing(doc);
        return doc;
    }

    private static void RemoveProcessingInstructions(Document doc) {
        List processingInstructions = doc.processingInstructions();
        for (String s : processingInstructions) {
            System.out.println("removing processing instruction : " + s);
            doc.removeProcessingInstruction(s);
        }
    }

    private static void RemoveAllNameSpacesExceptRelationship(Document doc) {
        RelationshipTransform.RemoveAllNameSpacesExceptRelationship(doc.getRootElement());
        for (Object e : doc.getRootElement().elements()) {
            RelationshipTransform.RemoveAllNameSpacesExceptRelationship((Element)e);
        }
    }

    public static void RemoveAllNameSpacesExceptRelationship(Element elem) {
        if (elem.getNamespace().getStringValue() != "http://schemas.openxmlformats.org/package/2006/relationships" || elem.getNamespace().getPrefix() != "") {
            elem.setQName(new QName(elem.getName(), DocumentFactory.getInstance().createNamespace("", "http://schemas.openxmlformats.org/package/2006/relationships")));
        }
        List additionalNameSpaces = elem.additionalNamespaces();
        for (Namespace nms : additionalNameSpaces) {
            elem.remove(nms);
        }
    }

    public static void SortRelationshipElementsById(Document doc) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("rel", "http://schemas.openxmlformats.org/package/2006/relationships");
        XPath xpath = DocumentHelper.createXPath((String)"//rel:Relationship");
        xpath.setNamespaceURIs(map);
        XPath sortXpath = DocumentHelper.createXPath((String)"@Id");
        List sortedElements = xpath.selectNodes((Object)doc, sortXpath);
        doc.getRootElement().setContent(sortedElements);
    }

    public static void FilterRelationshipsByTypeAndId(Document doc, List<String> pRelationshipIds, List<String> pRelationshipTypes) {
        if (pRelationshipIds == null) {
            return;
        }
        List rels = doc.getRootElement().elements();
        for (Element el : rels) {
            boolean isToBeRemoved = true;
            if (pRelationshipIds != null && pRelationshipIds.contains(el.attribute("Id").getValue())) {
                isToBeRemoved = false;
            }
            if (pRelationshipTypes != null && pRelationshipTypes.contains(el.attribute("Type").getValue())) {
                isToBeRemoved = false;
            }
            if (!isToBeRemoved) continue;
            el.detach();
        }
    }

    public static void RemoveContentsFromRelationshipElements(Document doc) {
        List rels = doc.getRootElement().elements();
        for (Element el : rels) {
            el.clearContent();
        }
    }

    public static void RemoveAllTopLevelComments(Document doc) {
        Vector<Node> tobeRemovedNodes = new Vector<Node>();
        for (int i = 0; i < doc.nodeCount(); ++i) {
            if (doc.node(i).getNodeType() != 8) continue;
            tobeRemovedNodes.add(doc.node(i));
        }
        for (Node tempNode : tobeRemovedNodes) {
            doc.remove(tempNode);
        }
    }

    public static void AddTargetModeInternalAttributeIfMissing(Document doc) {
        List rels = doc.getRootElement().elements();
        for (Element el : rels) {
            if (el.attribute("TargetMode") != null) continue;
            el.addAttribute("TargetMode", "Internal");
        }
    }
}

