/*
 * Decompiled with CFR 0.152.
 */
package org.openxml4j.opc.signature;

import java.io.OutputStream;
import java.io.StringWriter;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.ArrayList;
import javax.xml.crypto.Data;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.NodeSetData;
import javax.xml.crypto.XMLCryptoContext;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dom.DOMStructure;
import javax.xml.crypto.dsig.TransformException;
import javax.xml.crypto.dsig.TransformService;
import javax.xml.crypto.dsig.spec.TransformParameterSpec;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.jcp.xml.dsig.internal.dom.DOMUtils;
import org.dom4j.Document;
import org.dom4j.io.DOMWriter;
import org.openxml4j.exceptions.OpenXML4JException;
import org.openxml4j.opc.signature.DOMReader2;
import org.openxml4j.opc.signature.OX4JNodeSetData;
import org.openxml4j.opc.signature.RelationshipTransform;
import org.openxml4j.opc.signature.RelationshipTransformParameterSpec;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class RelationshipTransformService
extends TransformService {
    public static final String RELATIONSHIP_REFERENCE_TAG_NAME = "RelationshipReference";
    public static final String RELATIONSHIP_REFERENCE_SOURCE_ID_ATTR_NAME = "SourceId";
    public static final String RELATIONSHIP_REFERENCE_SOURCE_TYPE_ATTR_NAME = "SourceType";
    protected RelationshipTransformParameterSpec params;
    protected org.w3c.dom.Document ownerDoc;
    protected Element transformElem;

    @Override
    public void init(TransformParameterSpec arg0) throws InvalidAlgorithmParameterException {
        System.out.println("init-1");
        if (arg0 == null) {
            throw new NullPointerException("RelationshipParameterScep passed cannot be null");
        }
        if (!(arg0 instanceof RelationshipTransformParameterSpec)) {
            throw new InvalidAlgorithmParameterException();
        }
        this.params = (RelationshipTransformParameterSpec)arg0;
    }

    @Override
    public void init(XMLStructure arg0, XMLCryptoContext arg1) throws InvalidAlgorithmParameterException {
        System.out.println("init-2");
        if (arg0 == null) {
            throw new NullPointerException("Relationship transform passed cannot be null");
        }
        Element transformElem = (Element)((DOMStructure)arg0).getNode();
        try {
            this.setRelationshipTransformParameterSpecFromNode(transformElem);
        }
        catch (OpenXML4JException e) {
            throw new InvalidAlgorithmParameterException(e);
        }
    }

    @Override
    public void marshalParams(XMLStructure parent, XMLCryptoContext context) throws MarshalException {
        System.out.println("marshalParams");
        if (parent == null) {
            throw new NullPointerException();
        }
        this.transformElem = (Element)((DOMStructure)parent).getNode();
        this.ownerDoc = DOMUtils.getOwnerDocument((Node)this.transformElem);
        if (this.params != null && this.params.getRelationShipSourceIdsToInclude() != null) {
            for (String s : this.params.getRelationShipSourceIdsToInclude()) {
                Element relationshipRef = DOMUtils.createElement((org.w3c.dom.Document)this.ownerDoc, (String)RELATIONSHIP_REFERENCE_TAG_NAME, (String)"http://schemas.openxmlformats.org/package/2006/digital-signature", (String)"mdssi");
                DOMUtils.setAttribute((Element)relationshipRef, (String)RELATIONSHIP_REFERENCE_SOURCE_ID_ATTR_NAME, (String)s);
                relationshipRef.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:mdssi", "http://schemas.openxmlformats.org/package/2006/digital-signature");
                this.transformElem.appendChild(relationshipRef);
            }
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(this.transformElem), new StreamResult(writer));
                String xmlString = writer.getBuffer().toString();
                System.out.println(xmlString);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public AlgorithmParameterSpec getParameterSpec() {
        return this.params;
    }

    @Override
    public boolean isFeatureSupported(String arg0) {
        return false;
    }

    @Override
    public Data transform(Data arg0, XMLCryptoContext arg1) throws TransformException {
        System.out.println("transform-1");
        NodeSetData inData = (NodeSetData)arg0;
        return this.transformIt(inData);
    }

    @Override
    public Data transform(Data arg0, XMLCryptoContext arg1, OutputStream arg2) throws TransformException {
        System.out.println("transform-2");
        NodeSetData inData = (NodeSetData)arg0;
        return this.transformIt(inData);
    }

    private Data transformIt(NodeSetData inData) throws TransformException {
        Node relationshipsNode = ((OX4JNodeSetData)inData).getRootNode().getFirstChild();
        DOMReader2 dr = new DOMReader2();
        Document doc4j = dr.read(relationshipsNode);
        Document doc4jRet = null;
        try {
            doc4jRet = RelationshipTransform.DoRelationshipTransform(doc4j, this.params.getRelationShipSourceIdsToInclude(), this.params.getRelationshipSourceTypesToInclude());
            DOMWriter dw = new DOMWriter();
            org.w3c.dom.Document docRes = dw.write(doc4jRet);
            try {
                TransformerFactory tf = TransformerFactory.newInstance();
                Transformer transformer = tf.newTransformer();
                StringWriter writer = new StringWriter();
                transformer.transform(new DOMSource(docRes), new StreamResult(writer));
                String xmlString = writer.getBuffer().toString();
                System.out.println(xmlString);
            }
            catch (Exception tf) {
                // empty catch block
            }
            OX4JNodeSetData opcNodeSet = new OX4JNodeSetData(docRes);
            return opcNodeSet;
        }
        catch (Exception e) {
            throw new TransformException(e);
        }
    }

    private void setRelationshipTransformParameterSpecFromNode(Element pTransformElem) throws OpenXML4JException {
        NodeList transformparams = pTransformElem.getChildNodes();
        if (transformparams == null || transformparams.getLength() == 0) {
            throw new OpenXML4JException("Relationship transform specified , but no parameters given to relationship transform. ");
        }
        ArrayList<String> relationshipSourceIdsToInclude = null;
        ArrayList<String> relationshipSourceTypesToInclude = null;
        for (int i = 0; i < transformparams.getLength(); ++i) {
            Object relIdent = null;
            Node tempNode = null;
            NamedNodeMap nl = transformparams.item(i).getAttributes();
            tempNode = nl.getNamedItem(RELATIONSHIP_REFERENCE_SOURCE_ID_ATTR_NAME);
            if (tempNode != null) {
                if (relationshipSourceIdsToInclude == null) {
                    relationshipSourceIdsToInclude = new ArrayList<String>();
                }
                relationshipSourceIdsToInclude.add(tempNode.getNodeValue());
                continue;
            }
            tempNode = nl.getNamedItem(RELATIONSHIP_REFERENCE_SOURCE_TYPE_ATTR_NAME);
            if (tempNode != null) {
                if (relationshipSourceTypesToInclude == null) {
                    relationshipSourceTypesToInclude = new ArrayList<String>();
                }
                relationshipSourceTypesToInclude.add(tempNode.getNodeValue());
                continue;
            }
            throw new OpenXML4JException("Relationship transform parameter found but neither SourceId nor SourceType is not specified.");
        }
        this.params = new RelationshipTransformParameterSpec(relationshipSourceIdsToInclude, relationshipSourceTypesToInclude);
    }
}

